/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.config.AtomTypeFactoryTest")
public class AtomTypeFactory {
    public static final String ATOMTYPE_ID_STRUCTGEN = "structgen";
    public static final String ATOMTYPE_ID_MODELING = "modeling";
    public static final String ATOMTYPE_ID_JMOL = "jmol";
    private static final String TXT_EXTENSION = "txt";
    private static final String XML_EXTENSION = "xml";
    private static final String OWL_EXTENSION = "owl";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeFactory.class);
    private static Map<String, AtomTypeFactory> tables = null;
    private List<IAtomType> atomTypes = new ArrayList<IAtomType>(100);

    private AtomTypeFactory(String configFile, IChemObjectBuilder builder) {
        this.readConfiguration(configFile, builder);
    }

    private AtomTypeFactory(InputStream ins, String format, IChemObjectBuilder builder) {
        this.readConfiguration(ins, format, builder);
    }

    @TestMethod(value="testGetInstance_InputStream_String_IChemObjectBuilder")
    public static AtomTypeFactory getInstance(InputStream ins, String format, IChemObjectBuilder builder) {
        return new AtomTypeFactory(ins, format, builder);
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder")
    public static AtomTypeFactory getInstance(IChemObjectBuilder builder) {
        return AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", builder);
    }

    @TestMethod(value="testGetInstance_String_IChemObjectBuilder")
    public static AtomTypeFactory getInstance(String configFile, IChemObjectBuilder builder) {
        if (tables == null) {
            tables = new Hashtable<String, AtomTypeFactory>();
        }
        if (!tables.containsKey(configFile)) {
            tables.put(configFile, new AtomTypeFactory(configFile, builder));
        }
        return tables.get(configFile);
    }

    private void readConfiguration(String fileName, IChemObjectBuilder builder) {
        logger.info((Object)"Reading config file from ", new Object[]{fileName});
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (ins == null) {
            File file = new File(fileName);
            if (file.exists()) {
                logger.debug((Object)"configFile is a File");
                try {
                    ins = new FileInputStream(file);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    logger.debug((Object)exception);
                }
            } else {
                logger.error((Object)"no stream and no file");
            }
        }
        String format = XML_EXTENSION;
        if (fileName.endsWith(TXT_EXTENSION)) {
            format = TXT_EXTENSION;
        } else if (fileName.endsWith(XML_EXTENSION)) {
            format = XML_EXTENSION;
        } else if (fileName.endsWith(OWL_EXTENSION)) {
            format = OWL_EXTENSION;
        }
        this.readConfiguration(ins, format, builder);
    }

    private IAtomTypeConfigurator constructConfigurator(String format) {
        try {
            if (format.equals(TXT_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.TXTBasedAtomTypeConfigurator").newInstance();
            }
            if (format.equals(XML_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.CDKBasedAtomTypeConfigurator").newInstance();
            }
            if (format.equals(OWL_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.OWLBasedAtomTypeConfigurator").newInstance();
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Could not get instance of AtomTypeConfigurator for format ", new Object[]{format});
            logger.debug((Object)exc);
        }
        return null;
    }

    private void readConfiguration(InputStream ins, String format, IChemObjectBuilder builder) {
        IAtomTypeConfigurator atc = this.constructConfigurator(format);
        if (atc != null) {
            atc.setInputStream(ins);
            try {
                this.atomTypes = atc.readAtomTypes(builder);
            }
            catch (Exception exc) {
                logger.error((Object)"Could not read AtomType's from file due to: ", new Object[]{exc.getMessage()});
                logger.debug((Object)exc);
            }
        } else {
            logger.debug((Object)"AtomTypeConfigurator was null!");
            this.atomTypes = new ArrayList<IAtomType>();
        }
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.atomTypes.size();
    }

    @TestMethod(value="testGetAtomType_String,testGetAtomTypeFromJmol,testGetAtomTypeFromMM2,testGetAtomTypeFromPDB")
    public IAtomType getAtomType(String identifier) throws NoSuchAtomTypeException {
        for (IAtomType atomType : this.atomTypes) {
            if (!atomType.getAtomTypeName().equals(identifier)) continue;
            return atomType;
        }
        throw new NoSuchAtomTypeException("The AtomType " + identifier + " could not be found");
    }

    @TestMethod(value="testGetAtomTypes_String")
    public IAtomType[] getAtomTypes(String symbol) {
        logger.debug((Object)"Request for atomtype for symbol ", new Object[]{symbol});
        ArrayList<IAtomType> atomList = new ArrayList<IAtomType>();
        for (IAtomType atomType : this.atomTypes) {
            if (!atomType.getSymbol().equals(symbol)) continue;
            try {
                IAtomType clone = (IAtomType)atomType.clone();
                atomList.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)"Could not clone IAtomType: ", new Object[]{e.getMessage()});
                logger.debug((Object)e);
            }
        }
        IAtomType[] atomTypes = atomList.toArray(new IAtomType[atomList.size()]);
        if (atomTypes.length > 0) {
            logger.debug((Object)"Atomtype for symbol ", new Object[]{symbol, " has this number of types: " + atomTypes.length});
        } else {
            logger.debug((Object)"No atomtype for symbol ", new Object[]{symbol});
        }
        return atomTypes;
    }

    @TestMethod(value="testGetAllAtomTypes")
    public IAtomType[] getAllAtomTypes() {
        logger.debug((Object)"Returning list of size: ", new Object[]{this.getSize()});
        ArrayList<IAtomType> atomtypeList = new ArrayList<IAtomType>();
        for (IAtomType atomType : this.atomTypes) {
            try {
                IAtomType clone = (IAtomType)atomType.clone();
                atomtypeList.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)"Could not clone IAtomType: ", new Object[]{e.getMessage()});
                logger.debug((Object)e);
            }
        }
        return atomtypeList.toArray(new IAtomType[atomtypeList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TestMethod(value="testConfigure_IAtom")
    public IAtom configure(IAtom atom) throws CDKException {
        if (atom instanceof IPseudoAtom) {
            return atom;
        }
        try {
            IAtomType atomType;
            String atomTypeName = atom.getAtomTypeName();
            if (atomTypeName == null || atomTypeName.length() == 0) {
                logger.debug((Object)"Using atom symbol because atom type name is empty...");
                IAtomType[] types = this.getAtomTypes(atom.getSymbol());
                if (types.length <= 0) {
                    String message = "Could not configure atom with unknown ID: " + atom.toString() + " + (id=" + atom.getAtomTypeName() + ")";
                    logger.warn((Object)message);
                    throw new CDKException(message);
                }
                logger.warn((Object)"Taking first atom type, but other may exist");
                atomType = types[0];
            } else {
                atomType = this.getAtomType(atom.getAtomTypeName());
            }
            logger.debug((Object)"Configuring with atomtype: ", new Object[]{atomType});
            atom.setSymbol(atomType.getSymbol());
            atom.setMaxBondOrder(atomType.getMaxBondOrder());
            atom.setBondOrderSum(atomType.getBondOrderSum());
            atom.setCovalentRadius(atomType.getCovalentRadius());
            atom.setHybridization(atomType.getHybridization());
            Object color = atomType.getProperty((Object)"org.openscience.cdk.renderer.color");
            if (color != null) {
                atom.setProperty((Object)"org.openscience.cdk.renderer.color", color);
            }
            atom.setAtomicNumber(atomType.getAtomicNumber());
            atom.setExactMass(atomType.getExactMass());
        }
        catch (Exception exception) {
            logger.warn((Object)"Could not configure atom with unknown ID: ", new Object[]{atom, " + (id=", atom.getAtomTypeName(), ")"});
            logger.debug((Object)exception);
            throw new CDKException(exception.toString(), exception);
        }
        logger.debug((Object)"Configured: ", new Object[]{atom});
        return atom;
    }
}

