/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.HashMap;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.ExtendedTetrahedral;

public class ConnectivityChecker {
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(atomContainer));
        return cc.nComponents() == 1;
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container) {
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(container));
        return ConnectivityChecker.partitionIntoMolecules(container, cc.components());
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container, int[] components) {
        int maxComponentIndex = 0;
        for (int component : components) {
            if (component <= maxComponentIndex) continue;
            maxComponentIndex = component;
        }
        IAtomContainer[] containers = new IAtomContainer[maxComponentIndex + 1];
        HashMap<IAtom, IAtomContainer> componentsMap = new HashMap<IAtom, IAtomContainer>(2 * container.getAtomCount());
        for (int i = 1; i < containers.length; ++i) {
            containers[i] = container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        IAtomContainerSet containerSet = container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            componentsMap.put(container.getAtom(i), containers[components[i]]);
            containers[components[i]].addAtom(container.getAtom(i));
        }
        for (IBond bond : container.bonds()) {
            IAtomContainer endComp;
            IAtomContainer begComp = (IAtomContainer)componentsMap.get(bond.getBegin());
            if (begComp != (endComp = (IAtomContainer)componentsMap.get(bond.getEnd()))) continue;
            begComp.addBond(bond);
        }
        for (ISingleElectron electron : container.singleElectrons()) {
            ((IAtomContainer)componentsMap.get(electron.getAtom())).addSingleElectron(electron);
        }
        for (ILonePair lonePair : container.lonePairs()) {
            ((IAtomContainer)componentsMap.get(lonePair.getAtom())).addLonePair(lonePair);
        }
        for (IStereoElement stereo : container.stereoElements()) {
            if (stereo instanceof ITetrahedralChirality) {
                IAtom a = ((ITetrahedralChirality)stereo).getChiralAtom();
                if (!componentsMap.containsKey(a)) continue;
                ((IAtomContainer)componentsMap.get(a)).addStereoElement(stereo);
                continue;
            }
            if (stereo instanceof IDoubleBondStereochemistry) {
                IBond bond = ((IDoubleBondStereochemistry)stereo).getStereoBond();
                if (!componentsMap.containsKey(bond.getBegin()) || !componentsMap.containsKey(bond.getEnd())) continue;
                ((IAtomContainer)componentsMap.get(bond.getBegin())).addStereoElement(stereo);
                continue;
            }
            if (stereo instanceof ExtendedTetrahedral) {
                IAtom atom = ((ExtendedTetrahedral)stereo).focus();
                if (!componentsMap.containsKey(atom)) continue;
                ((IAtomContainer)componentsMap.get(atom)).addStereoElement(stereo);
                continue;
            }
            System.err.println("New stereochemistry element is not currently partitioned with ConnectivityChecker:" + stereo.getClass());
        }
        for (int i = 1; i < containers.length; ++i) {
            containerSet.addAtomContainer(containers[i]);
        }
        return containerSet;
    }
}

