/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryBond;

public class CTFileQueryBond
extends QueryBond
implements IQueryBond {
    protected Type type = (Type)((Object)CDKConstants.UNSET);

    public CTFileQueryBond(IChemObjectBuilder builder) {
        super(builder);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean matches(IBond bond) {
        return false;
    }

    public static CTFileQueryBond ofType(IBond bond, int type) {
        CTFileQueryBond queryBond = new CTFileQueryBond(bond.getBuilder());
        queryBond.setOrder(IBond.Order.UNSET);
        queryBond.setAtoms(new IAtom[]{bond.getBegin(), bond.getEnd()});
        switch (type) {
            case 1: {
                queryBond.setType(Type.SINGLE);
                break;
            }
            case 2: {
                queryBond.setType(Type.DOUBLE);
                break;
            }
            case 3: {
                queryBond.setType(Type.TRIPLE);
                break;
            }
            case 4: {
                queryBond.setType(Type.AROMATIC);
                break;
            }
            case 5: {
                queryBond.setType(Type.SINGLE_OR_DOUBLE);
                break;
            }
            case 6: {
                queryBond.setType(Type.SINGLE_OR_AROMATIC);
                break;
            }
            case 7: {
                queryBond.setType(Type.DOUBLE_OR_AROMATIC);
                break;
            }
            case 8: {
                queryBond.setType(Type.ANY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown bond type: " + type);
            }
        }
        return queryBond;
    }

    public static enum Type {
        SINGLE,
        DOUBLE,
        TRIPLE,
        AROMATIC,
        SINGLE_OR_DOUBLE,
        SINGLE_OR_AROMATIC,
        DOUBLE_OR_AROMATIC,
        ANY;

    }
}

