/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public final class ExtendedTetrahedral
implements IStereoElement {
    private final IAtom focus;
    private final IAtom[] peripherals;
    private final ITetrahedralChirality.Stereo winding;

    public ExtendedTetrahedral(IAtom focus, IAtom[] peripherals, ITetrahedralChirality.Stereo winding) {
        assert (focus != null && peripherals != null && winding != null);
        assert (peripherals.length == 4);
        this.focus = focus;
        this.peripherals = Arrays.copyOf(peripherals, 4);
        this.winding = winding;
    }

    public IAtom focus() {
        return this.focus;
    }

    public IAtom[] peripherals() {
        return Arrays.copyOf(this.peripherals, 4);
    }

    public ITetrahedralChirality.Stereo winding() {
        return this.winding;
    }

    public static IAtom[] findTerminalAtoms(IAtomContainer container, IAtom focus) {
        List<IBond> focusBonds = container.getConnectedBondsList(focus);
        if (focusBonds.size() != 2) {
            throw new IllegalArgumentException("focus must have exactly 2 neighbors");
        }
        IAtom left = focusBonds.get(0).getOther(focus);
        IAtom right = focusBonds.get(1).getOther(focus);
        return new IAtom[]{left, right};
    }

    public IAtom[] findTerminalAtoms(IAtomContainer container) {
        List<IBond> focusBonds = container.getConnectedBondsList(this.focus);
        if (focusBonds.size() != 2) {
            throw new IllegalArgumentException("focus must have exactly 2 neighbors");
        }
        IAtom left = focusBonds.get(0).getOther(this.focus);
        IAtom right = focusBonds.get(1).getOther(this.focus);
        List<IAtom> leftAtoms = container.getConnectedAtomsList(left);
        if (leftAtoms.contains(this.peripherals[2]) || leftAtoms.contains(this.peripherals[3])) {
            return new IAtom[]{right, left};
        }
        return new IAtom[]{left, right};
    }

    @Override
    public boolean contains(IAtom atom) {
        return this.focus.equals(atom) || this.peripherals[0].equals(atom) || this.peripherals[1].equals(atom) || this.peripherals[2].equals(atom) || this.peripherals[3].equals(atom);
    }

    @Override
    public IStereoElement map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        IAtom focus = atoms.containsKey(this.focus) ? atoms.get(this.focus) : this.focus;
        IAtom[] carriers = new IAtom[4];
        for (int i = 0; i < 4; ++i) {
            IAtom newAtom = atoms.get(this.peripherals[i]);
            carriers[i] = newAtom != null ? newAtom : this.peripherals[i];
        }
        return new ExtendedTetrahedral(focus, carriers, this.winding);
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        throw new UnsupportedOperationException("non-domain object");
    }
}

