/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.AtomicNumberRule;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;
import org.openscience.cdk.geometry.cip.rules.MassNumberRule;

class CombinedAtomicMassNumberRule
implements ISequenceSubRule<ILigand> {
    MassNumberRule massNumberRule = new MassNumberRule();
    AtomicNumberRule atomicNumberRule = new AtomicNumberRule();

    CombinedAtomicMassNumberRule() {
    }

    @Override
    public int compare(ILigand ligand1, ILigand ligand2) {
        int atomicNumberComp = this.atomicNumberRule.compare(ligand1, ligand2);
        if (atomicNumberComp != 0) {
            return atomicNumberComp;
        }
        int massNumberComp = this.massNumberRule.compare(ligand1, ligand2);
        if (massNumberComp != 0) {
            return massNumberComp;
        }
        if ("H".equals(ligand1.getLigandAtom().getSymbol())) {
            return 0;
        }
        return massNumberComp;
    }
}

