/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.templates.AminoAcids;

public class AminoAcidCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private IAtomContainerSet substructureSet;
    private static String[] names;

    public AminoAcidCountDescriptor() {
        AminoAcid[] aas = AminoAcids.createAAs();
        this.substructureSet = aas[0].getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (AminoAcid aa : aas) {
            this.substructureSet.addAtomContainer(aa);
        }
        names = new String[this.substructureSet.getAtomContainerCount()];
        for (int i = 0; i < aas.length; ++i) {
            AminoAcidCountDescriptor.names[i] = "n" + aas[i].getProperty("residueNameShort");
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#aminoAcidsCount", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer ac) {
        ac = AminoAcidCountDescriptor.clone(ac);
        int resultLength = this.substructureSet.getAtomContainerCount();
        IntegerArrayResult results = new IntegerArrayResult(resultLength);
        UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();
        for (int i = 0; i < resultLength; ++i) {
            List<List<RMap>> maps;
            IAtomContainer substructure = this.substructureSet.getAtomContainer(i);
            try {
                maps = universalIsomorphismTester.getSubgraphMaps(ac, substructure);
            }
            catch (CDKException e) {
                for (int j = 0; j < resultLength; ++j) {
                    results.add(0);
                }
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), new CDKException("Error in substructure search: " + e.getMessage()));
            }
            if (maps == null) continue;
            results.add(maps.size());
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(20);
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

