/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.IOException;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class MomentOfInertiaDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MomentOfInertiaDescriptor.class);
    private static final String[] NAMES = new String[]{"MOMI-X", "MOMI-Y", "MOMI-Z", "MOMI-XY", "MOMI-XZ", "MOMI-YZ", "MOMI-R"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#momentOfInertia", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        Isotopes factory;
        IAtomContainer clone;
        if (!GeometryUtil.has3DCoordinates(container)) {
            return this.getDummyDescriptorValue(new CDKException("Molecule must have 3D coordinates"));
        }
        try {
            clone = container.clone();
            factory = Isotopes.getInstance();
            factory.configureAtoms(clone);
        }
        catch (IOException | CloneNotSupportedException e) {
            logger.debug(e);
            return this.getDummyDescriptorValue(e);
        }
        DoubleArrayResult retval = new DoubleArrayResult(7);
        double ccf = 1.000138;
        double eps = 1.0E-5;
        double[][] imat = new double[3][3];
        Point3d centerOfMass = GeometryUtil.get3DCentreOfMass(clone);
        for (int i = 0; i < clone.getAtomCount(); ++i) {
            IAtom currentAtom = clone.getAtom(i);
            Double mass = factory.getMajorIsotope(currentAtom.getSymbol()).getExactMass();
            if (mass == null) {
                mass = factory.getNaturalMass(currentAtom);
            }
            double xdif = currentAtom.getPoint3d().x - centerOfMass.x;
            double ydif = currentAtom.getPoint3d().y - centerOfMass.y;
            double zdif = currentAtom.getPoint3d().z - centerOfMass.z;
            double xsq = xdif * xdif;
            double ysq = ydif * ydif;
            double zsq = zdif * zdif;
            double[] dArray = imat[0];
            dArray[0] = dArray[0] + mass * (ysq + zsq);
            double[] dArray2 = imat[1];
            dArray2[1] = dArray2[1] + mass * (xsq + zsq);
            double[] dArray3 = imat[2];
            dArray3[2] = dArray3[2] + mass * (xsq + ysq);
            double[] dArray4 = imat[1];
            dArray4[0] = dArray4[0] + -1.0 * mass * ydif * xdif;
            imat[0][1] = imat[1][0];
            double[] dArray5 = imat[2];
            dArray5[0] = dArray5[0] + -1.0 * mass * xdif * zdif;
            imat[0][2] = imat[2][0];
            double[] dArray6 = imat[2];
            dArray6[1] = dArray6[1] + -1.0 * mass * ydif * zdif;
            imat[1][2] = imat[2][1];
        }
        Matrix tmp = new Matrix(imat);
        EigenvalueDecomposition eigenDecomp = tmp.eig();
        double[] eval = eigenDecomp.getRealEigenvalues();
        retval.add(eval[2]);
        retval.add(eval[1]);
        retval.add(eval[0]);
        double etmp = eval[0];
        eval[0] = eval[2];
        eval[2] = etmp;
        if (Math.abs(eval[1]) > 0.001) {
            retval.add(eval[0] / eval[1]);
        } else {
            retval.add(1000.0);
        }
        if (Math.abs(eval[2]) > 0.001) {
            retval.add(eval[0] / eval[2]);
            retval.add(eval[1] / eval[2]);
        } else {
            retval.add(1000.0);
            retval.add(1000.0);
        }
        IMolecularFormula formula = MolecularFormulaManipulator.getMolecularFormula(clone);
        double pri = Math.abs(eval[2]) > eps ? Math.pow(eval[0] * eval[1] * eval[2], 0.3333333333333333) : Math.sqrt(eval[0] * ccf / MolecularFormulaManipulator.getTotalExactMass(formula));
        retval.add(Math.sqrt(Math.PI * 2 * pri * ccf / MolecularFormulaManipulator.getTotalExactMass(formula)));
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(7);
    }
}

