/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerComparatorBy2DCenter;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class BasicBondGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Double> bondWidth = new BondWidth();
    private IGeneratorParameter<Double> bondDistance = new BondDistance();
    private IGeneratorParameter<Color> defaultBondColor = new DefaultBondColor();
    private IGeneratorParameter<Double> wedgeWidth = new WedgeWidth();
    private IGeneratorParameter<Double> ringCenterProportion = new TowardsRingCenterProportion();
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(BasicBondGenerator.class);
    protected IRingSet ringSet;
    private Color overrideColor = null;
    private double overrideBondWidth = -1.0;
    private int IDEAL_RINGSIZE = 6;
    private double MIN_RINGSIZE_FACTOR = 2.5;

    public void setOverrideColor(Color color) {
        this.overrideColor = color;
    }

    public void setOverrideBondWidth(double bondWidth) {
        this.overrideBondWidth = bondWidth;
    }

    protected IRingSet getRingSet(IAtomContainer atomContainer) {
        IRingSet ringSet = atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        try {
            IAtomContainerSet molecules = ConnectivityChecker.partitionIntoMolecules(atomContainer);
            for (IAtomContainer mol : molecules.atomContainers()) {
                ringSet.add(Cycles.sssr(mol).toRingSet());
            }
            return ringSet;
        }
        catch (Exception exception) {
            this.logger.warn("Could not partition molecule: " + exception.getMessage());
            this.logger.debug(exception);
            return ringSet;
        }
    }

    public Color getColorForBond(IBond bond, RendererModel model) {
        if (this.overrideColor != null) {
            return this.overrideColor;
        }
        Color color = (Color)((Map)model.getParameter(RendererModel.ColorHash.class).getValue()).get(bond);
        if (color == null) {
            return (Color)model.getParameter(DefaultBondColor.class).getValue();
        }
        return color;
    }

    public double getWidthForBond(IBond bond, RendererModel model) {
        double scale = (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (this.overrideBondWidth != -1.0) {
            return this.overrideBondWidth / scale;
        }
        return (Double)model.getParameter(BondWidth.class).getValue() / scale;
    }

    @Override
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup group = new ElementGroup();
        this.ringSet = this.getRingSet(container);
        this.ringSet.sortAtomContainers(new AtomContainerComparatorBy2DCenter());
        for (IBond bond : container.bonds()) {
            group.add(MarkedElement.markupBond(this.generate(bond, model), bond));
        }
        return group;
    }

    @Override
    public IRenderingElement generate(IBond currentBond, RendererModel model) {
        IRing ring = RingSetManipulator.getHeaviestRing(this.ringSet, currentBond);
        if (ring != null) {
            return this.generateRingElements(currentBond, ring, model);
        }
        return this.generateBond(currentBond, model);
    }

    public IRenderingElement generateBondElement(IBond bond, RendererModel model) {
        return this.generateBondElement(bond, bond.getOrder(), model);
    }

    public IRenderingElement generateBondElement(IBond bond, IBond.Order type, RendererModel model) {
        if (bond.getAtomCount() > 2) {
            return null;
        }
        Point2d point1 = bond.getBegin().getPoint2d();
        Point2d point2 = bond.getEnd().getPoint2d();
        Color color = this.getColorForBond(bond, model);
        double bondWidth = this.getWidthForBond(bond, model);
        double bondDistance = (Double)model.get(BondDistance.class) / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (type == IBond.Order.SINGLE) {
            return new LineElement(point1.x, point1.y, point2.x, point2.y, bondWidth, color);
        }
        ElementGroup group = new ElementGroup();
        switch (type) {
            case DOUBLE: {
                this.createLines(point1, point2, bondWidth, bondDistance, color, group);
                break;
            }
            case TRIPLE: {
                this.createLines(point1, point2, bondWidth, bondDistance * 2.0, color, group);
                group.add(new LineElement(point1.x, point1.y, point2.x, point2.y, bondWidth, color));
                break;
            }
            case QUADRUPLE: {
                this.createLines(point1, point2, bondWidth, bondDistance, color, group);
                this.createLines(point1, point2, bondWidth, bondDistance * 4.0, color, group);
            }
        }
        return group;
    }

    private void createLines(Point2d point1, Point2d point2, double width, double dist, Color color, ElementGroup group) {
        double[] out = this.generateDistanceData(point1, point2, dist);
        LineElement l1 = new LineElement(out[0], out[1], out[4], out[5], width, color);
        LineElement l2 = new LineElement(out[2], out[3], out[6], out[7], width, color);
        group.add(l1);
        group.add(l2);
    }

    private double[] generateDistanceData(Point2d point1, Point2d point2, double dist) {
        Vector2d normal = new Vector2d();
        normal.sub(point2, point1);
        normal = new Vector2d(-normal.y, normal.x);
        normal.normalize();
        normal.scale(dist);
        Point2d line1p1 = new Point2d();
        Point2d line1p2 = new Point2d();
        line1p1.add(point1, normal);
        line1p2.add(point2, normal);
        normal.negate();
        Point2d line2p1 = new Point2d();
        Point2d line2p2 = new Point2d();
        line2p1.add(point1, normal);
        line2p2.add(point2, normal);
        return new double[]{line1p1.x, line1p1.y, line2p1.x, line2p1.y, line1p2.x, line1p2.y, line2p2.x, line2p2.y};
    }

    public IRenderingElement generateRingElements(IBond bond, IRing ring, RendererModel model) {
        if (this.isSingle(bond) && this.isStereoBond(bond)) {
            return this.generateStereoElement(bond, model);
        }
        if (this.isDouble(bond)) {
            ElementGroup pair2 = new ElementGroup();
            pair2.add(this.generateBondElement(bond, IBond.Order.SINGLE, model));
            pair2.add(this.generateInnerElement(bond, ring, model));
            return pair2;
        }
        return this.generateBondElement(bond, model);
    }

    public LineElement generateInnerElement(IBond bond, IRing ring, RendererModel model) {
        Point2d center = GeometryUtil.get2DCenter(ring);
        Point2d a = bond.getBegin().getPoint2d();
        Point2d b = bond.getEnd().getPoint2d();
        double distanceFactor = (Double)model.getParameter(TowardsRingCenterProportion.class).getValue();
        double ringDistance = distanceFactor * (double)this.IDEAL_RINGSIZE / (double)ring.getAtomCount();
        if (ringDistance < distanceFactor / this.MIN_RINGSIZE_FACTOR) {
            ringDistance = distanceFactor / this.MIN_RINGSIZE_FACTOR;
        }
        Point2d w = new Point2d();
        w.interpolate(a, center, ringDistance);
        Point2d u = new Point2d();
        u.interpolate(b, center, ringDistance);
        double alpha = 0.2;
        Point2d ww = new Point2d();
        ww.interpolate(w, u, alpha);
        Point2d uu = new Point2d();
        uu.interpolate(u, w, alpha);
        double width = this.getWidthForBond(bond, model);
        Color color = this.getColorForBond(bond, model);
        return new LineElement(u.x, u.y, w.x, w.y, width, color);
    }

    private IRenderingElement generateStereoElement(IBond bond, RendererModel model) {
        IBond.Stereo stereo = bond.getStereo();
        WedgeLineElement.TYPE type = WedgeLineElement.TYPE.WEDGED;
        WedgeLineElement.Direction dir = WedgeLineElement.Direction.toSecond;
        if (stereo == IBond.Stereo.DOWN || stereo == IBond.Stereo.DOWN_INVERTED) {
            type = WedgeLineElement.TYPE.DASHED;
        }
        if (stereo == IBond.Stereo.UP_OR_DOWN || stereo == IBond.Stereo.UP_OR_DOWN_INVERTED) {
            type = WedgeLineElement.TYPE.INDIFF;
        }
        if (stereo == IBond.Stereo.DOWN_INVERTED || stereo == IBond.Stereo.UP_INVERTED || stereo == IBond.Stereo.UP_OR_DOWN_INVERTED) {
            dir = WedgeLineElement.Direction.toFirst;
        }
        IRenderingElement base = this.generateBondElement(bond, IBond.Order.SINGLE, model);
        return new WedgeLineElement((LineElement)base, type, dir, this.getColorForBond(bond, model));
    }

    private boolean isDouble(IBond bond) {
        return bond.getOrder() == IBond.Order.DOUBLE;
    }

    private boolean isSingle(IBond bond) {
        return bond.getOrder() == IBond.Order.SINGLE;
    }

    private boolean isStereoBond(IBond bond) {
        return bond.getStereo() != IBond.Stereo.NONE && bond.getStereo() != (IBond.Stereo)((Object)CDKConstants.UNSET) && bond.getStereo() != IBond.Stereo.E_Z_BY_COORDINATES;
    }

    protected boolean bindsHydrogen(IBond bond) {
        for (int i = 0; i < bond.getAtomCount(); ++i) {
            IAtom atom = bond.getAtom(i);
            if (!"H".equals(atom.getSymbol())) continue;
            return true;
        }
        return false;
    }

    public IRenderingElement generateBond(IBond bond, RendererModel model) {
        boolean showExplicitHydrogens = true;
        if (model.hasParameter(BasicAtomGenerator.ShowExplicitHydrogens.class)) {
            showExplicitHydrogens = (Boolean)model.getParameter(BasicAtomGenerator.ShowExplicitHydrogens.class).getValue();
        }
        if (!showExplicitHydrogens && this.bindsHydrogen(bond)) {
            return null;
        }
        if (this.isStereoBond(bond)) {
            return this.generateStereoElement(bond, model);
        }
        return this.generateBondElement(bond, model);
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.bondWidth, this.defaultBondColor, this.wedgeWidth, this.bondDistance, this.ringCenterProportion);
    }

    public static class TowardsRingCenterProportion
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 0.15;
        }
    }

    public static class WedgeWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 2.0;
        }
    }

    public static class DefaultBondColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.BLACK;
        }
    }

    public static class BondDistance
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 2.0;
        }
    }

    public static class BondWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 1.0;
        }
    }
}

