/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import javax.vecmath.Point3d;
import org.openscience.cdk.hash.stereo.GeometricParity;

final class DoubleBond3DParity
extends GeometricParity {
    private final Point3d u;
    private final Point3d v;
    private final Point3d x;
    private final Point3d w;

    public DoubleBond3DParity(Point3d left, Point3d right, Point3d leftSubstituent, Point3d rightSubstituent) {
        this.u = left;
        this.v = right;
        this.x = leftSubstituent;
        this.w = rightSubstituent;
    }

    @Override
    public int parity() {
        double[] vu = DoubleBond3DParity.toVector(this.v, this.u);
        double[] vw = DoubleBond3DParity.toVector(this.v, this.w);
        double[] ux = DoubleBond3DParity.toVector(this.u, this.x);
        double[] normal = DoubleBond3DParity.crossProduct(vu, DoubleBond3DParity.crossProduct(vu, vw));
        int parity = (int)Math.signum(DoubleBond3DParity.dot(normal, vw)) * (int)Math.signum(DoubleBond3DParity.dot(normal, ux));
        return parity * -1;
    }

    private static double[] toVector(Point3d src, Point3d dest) {
        return new double[]{dest.x - src.x, dest.y - src.y, dest.z - src.z};
    }

    private static double dot(double[] u, double[] v) {
        return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
    }

    private static double[] crossProduct(double[] u, double[] v) {
        return new double[]{u[1] * v[2] - v[1] * u[2], u[2] * v[0] - v[2] * u[0], u[0] * v[1] - v[0] * u[1]};
    }
}

