/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractAmount;
import org.xmlcml.cml.element.AbstractSpectator;
import org.xmlcml.cml.element.CMLAmount;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.ReactionComponent;

public class CMLSpectator
extends AbstractSpectator
implements ReactionComponent {
    public static final String NS = "cml:spectator";

    public CMLSpectator() {
    }

    public CMLSpectator(CMLSpectator old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLSpectator(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLSpectator();
    }

    public void mergeChildMolecules() {
        Elements molecules = this.getChildCMLElements("molecule");
        if (molecules.size() != 2) {
            throw new RuntimeException("mergeChildMolecules requires exactly two child molecules");
        }
        CMLMolecule molecule0 = (CMLMolecule)molecules.get(0);
        CMLMolecule molecule1 = (CMLMolecule)molecules.get(1);
    }

    public void moveLabelledReactantsProducts(Elements reactProd, String ref) {
        boolean matched = false;
        if (reactProd != null) {
            for (int j = 0; j < reactProd.size(); ++j) {
                Elements labels = ((CMLElement)reactProd.get(j)).getChildCMLElements("label");
                for (int k = 0; k < labels.size(); ++k) {
                    CMLLabel label = (CMLLabel)labels.get(k);
                    if (!label.getValue().equals(ref)) continue;
                    CMLMolecule molecule = (CMLMolecule)((CMLElement)reactProd.get(j)).getFirstCMLChild("molecule");
                    try {
                        reactProd.get(j).detach();
                        this.appendChild((Node)molecule);
                        matched = true;
                        break;
                    }
                    catch (NullPointerException e) {
                        throw new RuntimeException("BUG " + e);
                    }
                }
                if (matched) break;
            }
        }
        if (!matched) {
            // empty if block
        }
    }

    @Override
    public List<CMLAtom> getAtoms() {
        return CMLReaction.getAtoms(this);
    }

    @Override
    public List<CMLBond> getBonds() {
        return CMLReaction.getBonds(this);
    }

    @Override
    public List<CMLFormula> getFormulas() {
        return CMLReaction.getFormulas(this);
    }

    @Override
    public List<CMLMolecule> getMolecules() {
        return CMLReaction.getMolecules(this);
    }

    public List<ReactionComponent> getReactionComponentDescendants() {
        return new ArrayList<ReactionComponent>();
    }

    public List<ReactionComponent> getReactionComponentChildren() {
        return new ArrayList<ReactionComponent>();
    }

    public CMLMolecule getMolecule() {
        Nodes molecules = this.query("./*[local-name()='molecule']");
        return molecules.size() == 1 ? (CMLMolecule)molecules.get(0) : null;
    }

    public void addAmount(AbstractAmount amount) {
        amount.detach();
        this.appendChild((Node)amount);
    }

    public CMLElements<CMLAmount> getAmountElements() {
        Elements elements = this.getChildElements("amount", "http://www.xml-cml.org/schema");
        return new CMLElements<CMLAmount>(elements);
    }
}

