% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.r
\name{publish}
\alias{publish}
\title{Publish your challenge R Markdown script to a html page.}
\usage{
publish(input = "challenge.rmd", output_file = NULL,
  output_dir = file.path("~/Dropbox/Public"), quiet = FALSE, ...)
}
\arguments{
\item{input}{string. name of the R Markdown input file}

\item{output_file}{output file. If \code{NULL} then a default based on the name 
of the input file is chosen.}

\item{output_dir}{string. output directory. default=\code{"~/Dropbox/Public"} 
so that the rendered page can easily be shared on the web with Dropbox.}

\item{quiet}{logical. deactivate text output.}

\item{...}{further arguments to pass to \code{\link[rmarkdown]{render}}.}
}
\value{
The compiled document is written into the output file, and the path 
  of the output file is returned.
}
\description{
Publish your challenge R Markdown script to a html page.
}
\examples{
path <- tempdir()
wd <- setwd(path)
new_challenge()
outdir = tempdir()
publish(output_dir = outdir, output_options = list(self_contained = FALSE))
unlink(outdir)
setwd(wd)
unlink(path)
}
\seealso{
\code{\link[rmarkdown]{render}}
}

