% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_count.R
\name{clinicaltrials_count}
\alias{clinicaltrials_count}
\title{Count number of results for a given search}
\usage{
clinicaltrials_count(query = NULL)
}
\arguments{
\item{query}{Search pattern as a string; a vector of key-value pairs is
interpreted as an advanced search and is therefore combined with '&'}
}
\value{
Number of results (integer).
}
\description{
Count the number of results for a given search. Useful to check before
attempting to pull down a very large number of records.
}
\examples{
# count trials satisfying 'heart disease AND stroke AND California'
\dontrun{clinicaltrials_count(query = 'heart disease AND stroke AND California')}

# advanced search for open, interventional trials involving melanoma
\dontrun{clinicaltrials_count(query = c('recr=Open', 'type=Intr', 'cond=melanoma'))}

# can also use a named list
\dontrun{clinicaltrials_count(query = list(recr='Open', type='Intr', cond='melanoma'))}

}

