% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseOrdinalIndependence.r
\name{pairwiseOrdinalIndependence}
\alias{pairwiseOrdinalIndependence}
\title{Pairwise tests of independence for tables with one ordered nominal variable}
\usage{
pairwiseOrdinalIndependence(
  x,
  compare = "row",
  scores = NULL,
  method = "fdr",
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A two-way contingency table. One dimension is ordered and one
is non-ordered nominal.}

\item{compare}{If \code{"row"}, treats the rows as the grouping variable.
If \code{"column"}, treats the columns as the grouping 
variable.}

\item{scores}{Optional vector to specify the spacing of the ordered
variable.}

\item{method}{The method to adjust multiple p-values. 
See \code{stats::p.adjust}.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments, passed to \code{stats::chisq_test}.}
}
\value{
A data frame of comparisons, p-values, and adjusted p-values.
}
\description{
Conducts pairwise tests for a 2-dimensional table,
             in which one variable is ordered nominal and one variable
             is non-ordered nominal.  
             The function relies on the \code{coin} package.
}
\examples{
### Independence test for table with one ordered variable
data(Breakfast)
require(coin)
chisq_test(Breakfast,
           scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
PT = pairwiseOrdinalIndependence(Breakfast, compare = "row")
PT
cldList(comparison = PT$Comparison, 
        p.value    = PT$p.value, 
        threshold  = 0.05)
        
### Similar to Kruskal-Wallis test for Likert data
data(PoohPiglet)
XT = xtabs(~ Speaker + Likert, data = PoohPiglet)
XT
require(coin)
chisq_test(XT,
           scores = list("Likert" = c(1, 2, 3, 4, 5)))
PT=pairwiseOrdinalIndependence(XT, compare = "row")
PT
cldList(comparison = PT$Comparison, 
        p.value    = PT$p.value, 
        threshold  = 0.05)         
                                                              
}
\references{
\url{http://rcompanion.org/handbook/H_09.html}
}
\seealso{
\code{\link{pairwiseNominalIndependence}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cochran-Armitage}
\concept{ordinal chi square}
\concept{post-hoc}
