% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{linesCMB}
\alias{linesCMB}
\title{Adds lines of fitted variograms to variogram plots}
\usage{
linesCMB(x, max.dist, scaled = FALSE, ...)
}
\arguments{
\item{x}{An object of the class \code{variofit} containing information about
the fitted model obtained as an output of the function \code{\link{variofitCMB}}.}

\item{max.dist}{A maximum distance to draw the variogram line. The default is
\code{x$max.dist}.}

\item{scaled}{logical. If TRUE the sill in the plot is 1.}

\item{...}{other plotting parameters passed to \code{\link[graphics]{curve}}}
}
\value{
A line with a fitted variogram model is added to a plot.
}
\description{
This function adds a line with the variogram model fitted by the function
\code{\link{variofitCMB}} to a current variogram plot. The function modifies
\code{\link[geoR]{lines.variomodel.variofit}} from the package \strong{geoR}
for additional covariance models on spheres.
}
\details{
The function adds a line with fitted variogram model to a plot. It is used
to compare empirical variograms against fitted models returned by
\code{\link{variofitCMB}}.

Available models are: "matern", "exponential",
"spherical", "powered.exponential", "cauchy", "gencauchy", "pure.nugget",
"askey", "c2wendland", "c4wendland", "sinepower", "multiquadric".
}
\examples{
## Plot the fitted Matern variogram versus its empirical variogram
#
# df <- CMBDataFrame("../CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 10000)
# varcmb <- variogramCMB(cmbdf, max.dist = 0.1, num.bins = 30)
# varcmb
# ols <- variofitCMB(varcmb,  fix.nug=FALSE, wei="equal", cov.model= "matern")
# plot(varcmb)
# lines(ols, lty=2)
#
## Plot the fitted Askey variogram versus its empirical variogram
#
# ols <- variofitCMB(vario1, ini.cov.pars = c(1, 0.03), fix.nug = TRUE,
#     kappa = 3, wei = "equal", cov.model = "askey")
# plot(varcmb, main = ols$cov.model)
# linesCMB(ols, lty = 2)

}
\references{
\strong{geoR} package, \code{\link[geoR]{lines.variomodel.variofit}},
\code{\link{covmodelCMB}}, \code{\link{variofitCMB}}
}
