% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestSearch.R
\name{neighbours}
\alias{neighbours}
\title{Return neighbouring pixels}
\usage{
neighbours(p, j)
}
\arguments{
\item{p}{Pixel index p at resolution j.}

\item{j}{The resolution parameter with nside = 2^j.}
}
\description{
Return the neighbouring pixels to a given pixel \eqn{p}
that is specified at resolution \eqn{j}, in the nested order.
}
\examples{
## Return the neighbouring pixels for base pixel 1
neighbours(1, 0)

## Plot the neighbouring pixels for base pixel 1
demoNeighbours <- function(p,j) {
  neighbours(p, j)
  displayPixels(boundary.j = j, j = j, plot.j = j+3,
                spix = neighbours(p, j),
                boundary.col = "gray",
                boundary.lwd = 1,
                incl.labels = neighbours(p, j),
                col = "blue",
                size = 3)
  rcosmo::displayPixelBoundaries(nside = 1, col = "blue", lwd = 3)
}

demoNeighbours(1,2)
demoNeighbours(1,0)

}
