% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conversion.R
\name{pix2coords}
\alias{pix2coords}
\title{Convert pixel indices to cartesian/spherical coordinates}
\usage{
pix2coords(nside, coords = "cartesian", ordering = "nested", spix)
}
\arguments{
\item{nside}{the nside parameter (integer number \eqn{2^k})}

\item{coords}{'cartesian' or 'spherical' coordinates}

\item{ordering}{'ring' or 'nested' ordering}

\item{spix}{optional integer or vector of sample pixel indices}
}
\value{
a data.frame with columns 'x', 'y', 'z' (cartesian) or
'theta', 'phi' (spherical)
}
\description{
Convert HEALPix pixel indices to cartesian or spherical coordinates
}
\examples{

pix2coords(nside=1, spix=c(2,5))
pix2coords(nside=1,  coords = "spherical", spix=c(2,5))

}
