% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{delineate_segments}
\alias{delineate_segments}
\title{Split a river corridor into segments}
\usage{
delineate_segments(corridor, network, river, angle_threshold = 100)
}
\arguments{
\item{corridor}{The river corridor as a simple feature geometry of class
\code{sfc_POLYGON}}

\item{network}{The spatial network of class \code{sfnetwork} to be used for the
segmentation}

\item{river}{The river centerline as a simple feature geometry of class
\code{\link[sf:sf]{sf::sf}} or \code{\link[sf:sfc]{sf::sfc}}}

\item{angle_threshold}{Only consider angles above this threshold (in degrees)
to form continuous strokes in the network. The value can range between
0 and 180, with the default set to 100. See \code{\link[rcoins:stroke]{rcoins::stroke()}} for more
details.}
}
\value{
Segment polygons as a simple feature geometry of class
\code{\link[sf:sfc]{sf::sfc_POLYGON}}
}
\description{
Segments are defined as corridor subregions separated by river-crossing
transversal lines that form continuous strokes in the network.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
corridor <- bucharest_dambovita$corridor
network <- rbind(bucharest_osm$streets, bucharest_osm$railways) |>
  as_network()
river <- bucharest_osm$river_centerline
delineate_segments(corridor, network, river)
\dontshow{\}) # examplesIf}
}
