% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delineate.R
\name{delineate}
\alias{delineate}
\title{Delineate a corridor around a river}
\usage{
delineate(
  city_name,
  river_name,
  crs = NULL,
  network_buffer = NULL,
  buildings_buffer = NULL,
  corridor_init = "valley",
  dem = NULL,
  dem_buffer = 2500,
  max_iterations = 10,
  capping_method = "shortest-path",
  angle_threshold = 100,
  corridor = TRUE,
  segments = FALSE,
  riverspace = FALSE,
  force_download = FALSE,
  ...
)
}
\arguments{
\item{city_name}{A character vector of length one}

\item{river_name}{A character vector of length one}

\item{crs}{The projected Coordinate Reference System (CRS) to use. If not
provided, the suitable Universal Transverse Mercator (UTM) CRS is selected}

\item{network_buffer}{Add a buffer (an integer in meters) around
river to retrieve additional data (streets, railways, etc.).
Default is 3000 m.}

\item{buildings_buffer}{Add a buffer (an integer in meters) around the
river to retrieve additional data (buildings). Default is 100 m.}

\item{corridor_init}{How to estimate the initial guess of the river corridor.
It can take the following values:
\itemize{
\item "valley": use the river valley boundary, as estimated from a Digital
Elevation Model (DEM) (for more info see \code{\link[=delineate_valley]{delineate_valley()}})
\item numeric or integer: use a buffer region of the given size (in meters)
around the river centerline
\item An \code{\link[sf:sf]{sf::sf}} or \code{\link[sf:sfc]{sf::sfc}} object: use the given input geometry
}}

\item{dem}{Digital elevation model (DEM) of the region (only used if
\code{corridor_init} is \code{"valley"})}

\item{dem_buffer}{Size of the buffer region (in meters) around the
river to retrieve the DEM  (only used if \code{corridor_init} is \code{"valley"} and
\code{dem} is NULL).}

\item{max_iterations}{Maximum number of iterations employed to refine the
corridor edges (see \code{\link[=corridor_edge]{corridor_edge()}}).}

\item{capping_method}{The method employed to connect the corridor edge end
points (i.e., to "cap" the corridor), as character vector of length one.
See \code{\link[=cap_corridor]{cap_corridor()}} for the available methods.}

\item{angle_threshold}{Only network edges forming angles above this threshold
(in degrees) are considered when forming segment edges. See
\code{\link[=delineate_segments]{delineate_segments()}} and \code{\link[rcoins:stroke]{rcoins::stroke()}}. Only used if \code{segments} is
TRUE.}

\item{corridor}{Whether to carry out the corridor delineation}

\item{segments}{Whether to carry out the corridor segmentation}

\item{riverspace}{Whether to carry out the riverspace delineation}

\item{force_download}{Download data even if cached data is available}

\item{...}{Additional (optional) input arguments for retrieving the DEM
dataset (see \code{\link[=get_dem]{get_dem()}}). Only relevant if \code{corridor_init} is \code{"valley"}
and \code{dem} is NULL}
}
\value{
A list with the corridor, segments, and riverspace geometries as
\code{\link[sf:sfc]{sf::sfc_POLYGON}} objects.
}
\description{
Delineate a corridor around a river
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set parameters
city <- "Bucharest"
river <- "Dâmbovița"

# Delineate with defaults
delineate(city, river)

# Use custom CRS
delineate(city, river, crs = "EPSG:31600")  # National projected CRS

# Use custom network buffer
delineate(city, river, network_buffer = 3500)

# Use custom buildings buffer
delineate(city, river, buildings_buffer = 150, riverspace = TRUE)

# Provide DEM as input
bucharest_dem <- get_dem_example_data()
delineate(city, river, dem = bucharest_dem)
\dontshow{\}) # examplesIf}
}
