% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cr_citation_count}
\alias{cr_citation_count}
\title{Lookup article info via CrossRef with DOI and get a citation count.}
\usage{
cr_citation_count(doi, url = "http://www.crossref.org/openurl/",
  key = "cboettig@ropensci.org", ...)
}
\arguments{
\item{doi}{digital object identifier for an article in PLoS Journals}

\item{url}{the PLoS API url for the function (should be left to default)}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\value{
citation count
}
\description{
Lookup article info via CrossRef with DOI and get a citation count.
}
\details{
See \url{http://labs.crossref.org/openurl/} for more info on this
		Crossref API service.
}
\examples{
\donttest{
cr_citation_count(doi="10.1371/journal.pone.0042793")
cr_citation_count(doi="10.1016/j.fbr.2012.01.001")
}
}
\author{
Carl Boettiger \email{cboettig@gmail.com}
}
\seealso{
\code{\link{cr_search}}, \code{\link{cr_r}}, \code{\link{cr_search_free}}
}

