% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd2d-package.R
\docType{package}
\name{rd2d-package}
\alias{rd2d-package}
\title{rd2d: Two Dimensional Local Polynomial Regression Discontinuity Design}
\description{
This package implements estimation and inference procedures for boundary regression discontinuity (RD) designs
using local polynomial methods, based on either bivariate coordinates or distance-based approaches.
Methods are developed in \href{https://rdpackages.github.io/references/Cattaneo-Titiunik-Yu_2025_BoundaryRD.pdf}{Cattaneo, Titiunik, and Yu (2025a)}. A companion software article is available
at \href{https://rdpackages.github.io/references/Cattaneo-Titiunik-Yu_2025_rd2d.pdf}{Cattaneo, Titiunik, and Yu (2025b)}.

Included functions are: \link{rd2d} for inference and estimation based on bivariate coordinates,
\link{rdbw2d} for data-driven bandwidth selection based on bivariate coordinates,
\link{rd2d.dist} for distance-based inference and estimation,
\link{rdbw2d.dist} for distance-based bandwidth selection.

\code{print()} and \code{summary()} methods are available all four functions.

Related Stata, R, and Python packages useful for inference in RD designs are described in the following website:

\href{ https://rdpackages.github.io/}{ https://rdpackages.github.io/}

For an introduction to regression discontinuity design, see \href{https://www.cambridge.org/core/elements/practical-introduction-to-regression-discontinuity-designs/C6A70A32359115510AAC370A7869AE2F}{Cattaneo, Idrobo, Titiunik (2024)} and references therein.
}
\references{
\itemize{
\item{\href{https://rdpackages.github.io/references/Cattaneo-Titiunik-Yu_2025_BoundaryRD.pdf}{Cattaneo, M. D., Titiunik, R., Yu, R. R. (2025a).}
Estimation and Inference in Boundary Discontinuity Designs}
\item{\href{https://rdpackages.github.io/references/Cattaneo-Titiunik-Yu_2025_rd2d.pdf}{Cattaneo, M. D., Titiunik, R., Yu, R. R. (2025b).}
rd2d: Causal Inference in Boundary Discontinuity Designs}
\item{\href{https://www.cambridge.org/core/elements/practical-introduction-to-regression-discontinuity-designs/C6A70A32359115510AAC370A7869AE2F}{Cattaneo, M. D., Idrobo, N., Titiunik, R. (2024).}
A Practical Introduction to Regression Discontinuity Designs: Extensions}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rdpackages.github.io/rd2d/}
}

}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.
Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
Ruiqi Rae Yu, Princeton University. \email{rae.yu@princeton.edu}.
}
