% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install_mysql}
\alias{install_mysql}
\title{Install datasets via the Data Retriever.}
\usage{
install_mysql(
  dataset,
  user = "root",
  password = "",
  host = "localhost",
  port = 3306,
  database_name = "{db}",
  table_name = "{db}.{table}",
  debug = FALSE,
  use_cache = TRUE,
  force = FALSE,
  hash_value = NULL
)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to install or path to a committed dataset zip file}

\item{user}{username for database connection}

\item{password}{password for database connection}

\item{host}{hostname for connection}

\item{port}{port number for connection}

\item{database_name}{database name in which dataset will be installed}

\item{table_name}{table name specified especially for datasets
containing one file}

\item{debug}{setting TRUE helps in debugging in case of errors}

\item{use_cache}{setting FALSE reinstalls scripts even if they are already installed}

\item{force}{setting TRUE doesn't prompt for confirmation while installing committed datasets when changes are discovered in environment}

\item{hash_value}{the hash value of committed dataset when installing from provenance directory}
}
\value{
No return value, installs datasets into MySQL database
}
\description{
Data is stored in MySQL database
}
\examples{
\dontrun{
rdataretriever::install_mysql(dataset = "portal", user = "postgres", password = "abcdef")
}
}
