% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_impute.R
\name{rd_impute}
\alias{rd_impute}
\title{Multiple Imputation of Regression Discontinuity Estimation}
\usage{
rd_impute(
  formula,
  data,
  subset = NULL,
  cutpoint = NULL,
  bw = NULL,
  kernel = "triangular",
  se.type = "HC1",
  cluster = NULL,
  impute = NULL,
  verbose = FALSE,
  less = FALSE,
  est.cov = FALSE,
  est.itt = FALSE,
  t.design = NULL
)
}
\arguments{
\item{formula}{The formula of the RDD. This is supplied in the
format of \code{y ~ x} for a simple sharp RDD, or \code{y ~ x | c1 + c2}
for a sharp RDD with two covariates. Fuzzy RDD may be specified as
\code{y ~ x + z} where \code{x} is the running variable, and 
\code{z} is the endogenous treatment variable. Covariates are then included in the 
same manner as in a sharp RDD.}

\item{data}{An optional data frame.}

\item{subset}{An optional vector specifying a subset of observations to be used}

\item{cutpoint}{The cutpoint. If omitted, it is assumed to be 0.}

\item{bw}{A numeric vector specifying the bandwidths at which to estimate the RD. 
If omitted or it is \code{"IK12"}, the bandwidth is calculated using the Imbens-Kalyanaraman 
2012 method. If it is \code{"IK09"}, the bandwidth is calculated using 
the Imbens-Kalyanaraman 2009 method. Then it is estimated
with that bandwidth, half that bandwidth, and twice that bandwidth.  
If only a single value is passed into the function,
the RD will similarly be estimated at that bandwidth, half that bandwidth, 
and twice that bandwidth.}

\item{kernel}{A string specifying the kernel to be used in the local linear fitting. 
\code{"triangular"} kernel is the default and is the "correct" theoretical kernel to be 
used for edge estimation as in RDD (Lee and Lemieux, 2010). Other options are 
\code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, \code{"gaussian"} and \code{"cosine"}.}

\item{se.type}{This specifies the robust SE calculation method to use. Options are,
as in \code{\link{vcovHC}}, \code{"HC3"}, \code{"const"}, \code{"HC"}, \code{"HC0"}, 
\code{"HC1"}, \code{"HC2"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. This option 
is overridden by \code{cluster}.}

\item{cluster}{An optional vector specifying clusters within which the errors are assumed
to be correlated. This will result in reporting cluster robust SEs. This option overrides
anything specified in \code{se.type}. It is suggested that data with a discrete running 
variable be clustered by each unique value of the running variable (Lee and Card, 2008).}

\item{impute}{An optional vector specifying the imputed variables with missing values.}

\item{verbose}{Will provide some additional information printed to the terminal.}

\item{less}{Logical. If \code{TRUE}, return the estimates of linear and optimal, 
instead of linear, quadratic, cubic, optimal, half and double.}

\item{est.cov}{Logical. If \code{TRUE}, the estimates of covariates will be included.}

\item{est.itt}{Logical. If \code{TRUE}, the estimates of ITT will be returned.}

\item{t.design}{The treatment option according to design.
The entry is for X: \code{"g"} means treatment is assigned 
if X is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X is less than its cutoff, \code{"leq"} means treatment is assigned 
if X is less than or equal to its cutoff.}
}
\value{
\code{rd_impute} returns an object of \link{class} "\code{rd}".
}
\description{
\code{rd_impute} estimates treatment effects in a RDD with imputed missing values.
}
\examples{
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x < 0) + rnorm(1000)
group <- rep(1:10, each = 100)
rd_impute(y ~ x, impute = group, t.design = "l")
# Efficiency gains can be made by including covariates
rd_impute(y ~ x | cov, impute = group, t.design = "l")
}
\references{
Stata: 64 mi estimate - Estimation using multiple imputations
}
