% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LeafNode.R
\docType{class}
\name{LeafNode}
\alias{LeafNode}
\title{\verb{LeafNode} class}
\description{
An R6 class for a leaf node in a decision tree representing a clinical state.
}
\details{
Represents a terminal state in a tree, and is associated with an
incremental utility.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Node]{rdecision::Node}} -> \code{LeafNode}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LeafNode$new()}}
\item \href{#method-modvars}{\code{LeafNode$modvars()}}
\item \href{#method-utility}{\code{LeafNode$utility()}}
\item \href{#method-interval}{\code{LeafNode$interval()}}
\item \href{#method-QALY}{\code{LeafNode$QALY()}}
\item \href{#method-clone}{\code{LeafNode$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="label">}\href{../../rdecision/html/Node.html#method-label}{\code{rdecision::Node$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="type">}\href{../../rdecision/html/Node.html#method-type}{\code{rdecision::Node$type()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LeafNode} object; synonymous with a clinical outcome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$new(
  label,
  utility = 1,
  interval = as.difftime(365.25, units = "days")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Character string; a label for the state; must be
defined because it is used in tabulations. The label is automatically
converted to a syntactically valid (in R) name to ensure it can be used
as a column name in a data frame.}

\item{\code{utility}}{The incremental utility that a user associates with
being in the health state (range \code{-Inf} to 1) for the interval.
Intended for use with cost benefit analysis.}

\item{\code{interval}}{The time interval over which the \code{utility}
parameter applies, expressed as an R \code{difftime} object; default 
1 year.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LeafNode} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \code{ModVar} that have been 
specified as values associated with this \code{LeafNode}. Includes 
operands of these \code{ModVar}s, if they are expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-utility"></a>}}
\if{latex}{\out{\hypertarget{method-utility}{}}}
\subsection{Method \code{utility()}}{
Return the incremental utility associated with being in the state for
the interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$utility()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Incremental utility (numeric value).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval"></a>}}
\if{latex}{\out{\hypertarget{method-interval}{}}}
\subsection{Method \code{interval()}}{
Return the interval associated with being in the state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$interval()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Interval (as a \code{difftime}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QALY"></a>}}
\if{latex}{\out{\hypertarget{method-QALY}{}}}
\subsection{Method \code{QALY()}}{
Return the quality adjusted life years associated with being in 
the state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$QALY()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\acronym{QALY}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LeafNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
