% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Action.R
\docType{class}
\name{Action}
\alias{Action}
\title{An action in a decision tree}
\description{
R6 class representing an action (choice) edge.
}
\details{
A specialism of class \code{Arrow} which is used in a decision tree
to represent an edge whose source node is a \code{DecisionNode}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{\link[rdecision:Arrow]{rdecision::Arrow}} -> \code{Action}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Action$new()}}
\item \href{#method-modvars}{\code{Action$modvars()}}
\item \href{#method-p}{\code{Action$p()}}
\item \href{#method-cost}{\code{Action$cost()}}
\item \href{#method-benefit}{\code{Action$benefit()}}
\item \href{#method-clone}{\code{Action$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints">}\href{../../rdecision/html/Edge.html#method-endpoints}{\code{rdecision::Edge$endpoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge">}\href{../../rdecision/html/Edge.html#method-is_same_edge}{\code{rdecision::Edge$is_same_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label">}\href{../../rdecision/html/Edge.html#method-label}{\code{rdecision::Edge$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="source">}\href{../../rdecision/html/Arrow.html#method-source}{\code{rdecision::Arrow$source()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="target">}\href{../../rdecision/html/Arrow.html#method-target}{\code{rdecision::Arrow$target()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{Action}. Optionally, a cost and a benefit 
may 
be associated with traversing the edge. A \dfn{pay-off} (benefit minus 
cost)  is sometimes used in edges of decision trees; the parametrization
used here is more general.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$new(source, target, label, cost = 0, benefit = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{Decision node from which the arrow leaves.}

\item{\code{target}}{Node to which the arrow points.}

\item{\code{label}}{Character string containing the arrow label. This
must be defined for an action because the label is used in
tabulation of strategies. It is recommended to choose labels that are
brief and not punctuated with spaces, dots or underscores.}

\item{\code{cost}}{Cost associated with traversal of this edge.}

\item{\code{benefit}}{Benefit associated with traversal of the edge.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Action} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \code{ModVar} that have been 
specified
as values associated with this \code{Action}. Includes operands of these
\code{ModVar}s, if they are expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-p"></a>}}
\if{latex}{\out{\hypertarget{method-p}{}}}
\subsection{Method \code{p()}}{
Return the current value of the edge probability, i.e. the conditional
probability of traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$p()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric value equal to 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cost"></a>}}
\if{latex}{\out{\hypertarget{method-cost}{}}}
\subsection{Method \code{cost()}}{
Return the cost associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Cost.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-benefit"></a>}}
\if{latex}{\out{\hypertarget{method-benefit}{}}}
\subsection{Method \code{benefit()}}{
Return the benefit associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$benefit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Benefit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
