% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContactService.R
\name{dfp_getContactsByStatement}
\alias{dfp_getContactsByStatement}
\title{getContactsByStatement}
\usage{
dfp_getContactsByStatement(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getContactsByStatementResponse
}
\description{
Gets a ContactPage of Contact objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{name}
  \item{email}
  \item{id}
  \item{comment}
  \item{companyId}
  \item{title}
  \item{cellPhone}
  \item{workPhone}
  \item{faxPhone}
  \item{status}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getContactsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ContactService#getContactsByStatement}{Google Documentation for getContactsByStatement}
}
