% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomFieldService.R
\name{dfp_createCustomFieldOptions}
\alias{dfp_createCustomFieldOptions}
\title{CustomFieldService}
\usage{
dfp_createCustomFieldOptions(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCustomFieldOptionsResponse
}
\description{
Provides methods for the creation and management of CustomField objects.
}
\details{
createCustomFieldOptions

Creates new CustomFieldOption objects. The following fields are required: 
\itemize{
  \item{CustomFieldOption displayName}
  \item{CustomFieldOption customFieldId}
}
}
\examples{
\dontrun{
request_data <- data.frame(customFieldId=rep(dfp_createCustomFields_result$id, 3),
                           displayName=c('Morning', 'Afternoon', 'Evening'))
result <- dfp_createCustomFieldOptions(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CustomFieldService#createCustomFieldOptions}{Google Documentation for createCustomFieldOptions}
}
