% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportService.R
\name{dfp_getReportDownloadURL}
\alias{dfp_getReportDownloadURL}
\title{ReportService}
\usage{
dfp_getReportDownloadURL(request_data, as_df = FALSE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getReportDownloadURLResponse
}
\description{
Provides methods for executing a ReportJob and retrieving performance and
statistics about ad campaigns, networks, inventory and sales.
Follow the
steps outlined below:
\itemize{
  \item{Create the ReportJob object by
invoking ReportService#runReportJob.}
  \item{Poll the ReportJob object
using ReportService#getReportJob.}
  \item{Continue to poll the ReportJob
object until the ReportJob#reportJobStatus field is equal to
ReportJobStatus#COMPLETED or ReportJobStatus#FAILED.}
  \item{If
successful, fetch the URL for downloading the report by invoking
ReportService#getReportDownloadURL.}
} <h4>Test network
behavior</h4>
The networks created using NetworkService#makeTestNetwork
are unable to provide reports that would be comparable to the production
environment because reports require traffic history. In the test networks,
reports will consistently return no data for all reports.
}
\details{
getReportDownloadURL

Returns the URL at which the report file can be downloaded.
The report will be generated as a gzip archive, containing the report file itself.
}
\examples{
\dontrun{
request_data <- list(reportJob=
                       list(reportQuery=
                              list(dimensions='MONTH_AND_YEAR', 
                                   dimensions='AD_UNIT_ID',
                                   adUnitView='FLAT',
                                   columns='AD_SERVER_CLICKS', 
                                   dateRangeType='LAST_WEEK')))

# the result is a list and most importantly the ID is included for checking its status
dfp_runReportJob_result <- dfp_runReportJob(request_data)

# only run after the status is "COMPLETED"
request_data <- list(reportJobId=dfp_runReportJob_result$id, exportFormat='CSV_DUMP')
dfp_getReportDownloadURL_result <- dfp_getReportDownloadURL(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ReportService#getReportDownloadURL}{Google Documentation for getReportDownloadURL}
}
