% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-metacommunity.R, R/metacommunity.R
\docType{class}
\name{metacommunity-class}
\alias{metacommunity-class}
\alias{show,metacommunity-method}
\title{metacommunity-class}
\usage{
\S4method{show}{metacommunity}(object)
}
\arguments{
\item{object}{object of class \code{metacommunity}}
}
\description{
Container for class \code{metacommunity}.
}
\section{Fields}{

\describe{
\item{\code{type_abundance}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types (species), columns as subcommunities, and each
element containing the relative abundance of types in each subcommunity
relative to the metacommunity as a whole. In the phylogenetic case, this
corresponds to the proportional abundance of historical species, which is
calculated from the proportional abundance of terminal taxa}

\item{\code{similarity}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as types, and elements containing the pairwise
similarity of types}

\item{\code{similarity_components}}{list containing the components necessary to
calculate similarity. This list is empty when \code{precompute_dist = TRUE}
when calculating distance. When a pairwise distance matrix is too large and
\code{precompute_dist = FALSE}, this list contains all the information
required to calculate pairwise distance between types}

\item{\code{similarity_parameters}}{list containing parameters associated with
converting pairwise distances to similarities (the \code{dist2sim()}
arguments)}

\item{\code{ordinariness}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing the
ordinariness of types within subcommunities}

\item{\code{subcommunity_weights}}{\code{vector} of mode \code{numeric} containing
subcommunity weights}

\item{\code{type_weights}}{two-dimensional \code{matrix} of mode \code{numeric},
with rows as types, columns as subcommunities, and elements containing
weights of types within a subcommunity}

\item{\code{dat_id}}{object of class \code{character} describing the class of
distance / similarity being used, e.g. "naive", "taxonomic", and so on}

\item{\code{raw_abundance}}{[Phylogenetic] two-dimensional \code{matrix} of mode
\code{numeric} with rows as types, columns as subcommunities, and elements
containing the relative abundance of present day species}

\item{\code{raw_structure}}{[Phylogenetic] two-dimensional \code{matrix} of mode
\code{numeric} with rows as historical species, columns as present day
species, and elements containing historical species lengths within lineages}

\item{\code{parameters}}{[Phylogenetic] \code{data.frame} containing parameters
associated with each historic species in the phylogeny}
}}

