% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdmcplot.R
\name{rdmcplot}
\alias{rdmcplot}
\title{RD plots with multiple cutoffs.}
\usage{
rdmcplot(Y, X, C, hvec = NULL, pvec = NULL, noscatter = FALSE,
  nodraw = FALSE)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{cutoff variable.}

\item{hvec}{bandwidths to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{pvec}{order of the polynomials to be passed to \code{rdrobust()} to calculate cutoff-specific estimates. Should be a vector of length equal to the number of different cutoffs.}

\item{noscatter}{omits scatter plot.}

\item{nodraw}{omits plot.}
}
\value{
\item{clist}{list of cutoffs}
\item{cnum}{number of cutoffs}
\item{X0}{matrix of X values for control units}
\item{X1}{matrix of X values for treated units}
\item{Yhat0}{estimated polynomial for control units}
\item{Yhat1}{estimated polynomial for treated units}
\item{Xmean}{bin average of X values}
\item{Ymean}{bin average for Y values}
}
\description{
\code{rdmc()} RD plots with multiple cutoffs.
}
\examples{
# Toy dataset
X <- runif(1000,0,100)
C <- c(rep(33,500),rep(66,500))
Y <- (1 + X + (X>=C))*(C==33)+(.5 + .5*X + .8*(X>=C))*(C==66) + rnorm(1000)
# rdmcplot with standard syntax
tmp <- rdmcplot(Y,X,C)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2018). \href{https://sites.google.com/site/rdpackages/rdmulti/Cattaneo-Titiunik-VazquezBare_2018_rdmulti.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Working paper, University of Michigan}.
}
\author{
Matias Cattaneo, University of Michigan. \email{cattaneo@umich.edu}

Rocio Titiunik, University of Michigan. \email{titiunik@umich.edu}

Gonzalo Vazquez-Bare, University of Michigan. \email{gvazquez@umich.edu}
}
