% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsampsi.R
\name{rdsampsi}
\alias{rdsampsi}
\title{Sample Size Calculations for RD Designs}
\usage{
rdsampsi(
  data = NULL,
  cutoff = 0,
  tau = NULL,
  alpha = 0.05,
  beta = 0.8,
  samph = NULL,
  nsamples = NULL,
  all = FALSE,
  bias = NULL,
  variance = NULL,
  nratio = NULL,
  init.cond = NULL,
  plot = FALSE,
  graph.range = NULL,
  covs = NULL,
  covs_drop = TRUE,
  deriv = 0,
  p = 1,
  q = NULL,
  h = NULL,
  b = NULL,
  rho = NULL,
  kernel = "triangular",
  bwselect = "mserd",
  vce = "nn",
  cluster = NULL,
  scalepar = 1,
  scaleregul = 1,
  fuzzy = NULL,
  level = 95,
  weights = NULL,
  masspoints = "adjust",
  bwcheck = NULL,
  bwrestrict = TRUE,
  stdvars = FALSE
)
}
\arguments{
\item{data}{a matrix (Y,R) containing the outcome variable and the running variable (as column vectors).}

\item{cutoff}{the RD cutoff (default is 0).}

\item{tau}{specifies the treatment effect under the alternative at which the power function is evaluated. The default is half the standard deviation of the outcome for the untreated group.}

\item{alpha}{specifies the significance level for the power function. Default is 0.05.}

\item{beta}{specifies the desired power. Default is 0.8.}

\item{samph}{sets the bandwidths at each side of the cutoff for power calculation. The first number is the bandwidth to the left of the cutoff and the second number is the bandwidth to the right.  Default values are the bandwidths used by \code{rdrobust}.}

\item{nsamples}{sets the total sample size to the left, sample size to the left inside the bandwidth, total sample size to the right and sample size to the right of the cutoff inside the bandwidth to calculate the variance when the running variable is not specified. When not specified, the values are calculated using the running variable.}

\item{all}{displays the power using the conventional variance estimator, in addition to the robust bias corrected one.}

\item{bias}{set bias to the left and right of the cutoff. If not specified, the biases are estimated using \code{rdrobust}.}

\item{variance}{set variance to the left and right of the cutoff. If not specified, the variances are estimated using \code{rdrobust}.}

\item{nratio}{specifies the proportion of treated units in the window. Default is the ratio of the standard deviation of the treated to the sum of the standard deviations for treated and controls.}

\item{init.cond}{sets the initial condition for the Newton-Raphson algorithm that finds the sample size.  Default is the number of observations in the sample with non-missing values of the outcome and running variable.}

\item{plot}{plots the power function using the conventional and robust bias corrected standard errors from \code{rdrobust}.}

\item{graph.range}{range of the plot.}

\item{covs}{option for \code{rdrobust()}: specifies additional covariates to be used for estimation and inference.}

\item{covs_drop}{option for \code{rdrobust()}: if TRUE, it checks for collinear additional covariates and drops them. Default is TRUE.}

\item{deriv}{option for \code{rdrobust()}: specifies the order of the derivative of the regression functions to be estimated.}

\item{p}{option for \code{rdrobust()}: specifies the order of the local-polynomial used to construct the point-estimator.}

\item{q}{option for \code{rdrobust()}: specifies the order of the local-polynomial used to construct the bias-correction.}

\item{h}{option for \code{rdrobust()}: specifies the values of the main bandwidth to be used on the left and on the right of the cutoff, respectively.}

\item{b}{option for \code{rdrobust()}: specifies the values of the bias bandwidth $b$ to be used on the left and on the right of the cutoff, respectively.}

\item{rho}{option for \code{rdrobust()}: specifies the value of \code{rho} so that the bias bandwidth \code{b} equals \code{b=h/rho}.}

\item{kernel}{option for \code{rdrobust()}: kernel function used to construct the local-polynomial estimators.}

\item{bwselect}{option for \code{rdrobust()}: specifies the bandwidth selection procedure to be used.}

\item{vce}{option for \code{rdrobust()}: specifies the procedure used to compute the variance-covariance matrix estimator.}

\item{cluster}{option for \code{rdrobust()}: indicates the cluster ID variable used for the cluster-robust variance estimation with degrees-of-freedom weights.}

\item{scalepar}{option for \code{rdrobust()}: specifies scaling factor for RD parameter of interest.}

\item{scaleregul}{option for \code{rdrobust()}: specifies scaling factor for the regularization terms of bandwidth selectors.}

\item{fuzzy}{option for \code{rdrobust()}: specifies the treatment status variable used to implement fuzzy RD estimation.}

\item{level}{option for \code{rdrobust()}: sets the confidence level for confidence intervals.}

\item{weights}{option for \code{rdrobust()}: is the variable used for optional weighting of the estimation procedure. The unit-specific weights multiply the kernel function.}

\item{masspoints}{option for \code{rdrobust()}: checks and controls for repeated observations in tue running variable.}

\item{bwcheck}{option for \code{rdrobust()}: if a positive integer is provided, the preliminary bandwidth used in the calculations is enlarged so that at least \code{bwcheck} unique observations are used.}

\item{bwrestrict}{option for \code{rdrobust()}: if TRUE, computed bandwidths are restricted to lie withing the range of \code{x}. Default is \code{bwrestrict=TRUE}.}

\item{stdvars}{option for \code{rdrobust()}: if \code{TRUE}, \code{x} and \code{y} are standardized before computing the bandwidths. Default is \code{stdvars=TRUE}.}
}
\value{
\item{alpha}{significance level}
\item{beta}{desired power}
\item{tau}{treatment effect under alternative hypothesis}
\item{sampsi.h.tot}{total number of observations inside the window}
\item{sampsi.h.r}{number of observations inside the window to the right of the cutoff}
\item{sampsi.h.l}{number of observations inside the window to the left of the cutoff}
\item{N.r}{Total sample size to the right of the cutoff}
\item{N.l}{Total sample size to the left of the cutoff}
\item{samph.r}{bandwidth to the right of the cutoff}
\item{samph.l}{bandwidth to the left of the cutoff}
\item{var.r}{Robust bias corrected variance to the right of the cutoff}
\item{Var.l}{Robust bias corrected variance to the left of the cutoff}
\item{sampsi.h.tot.cl}{implied total number of observations inside the window using conventional s.e.}
\item{sampsi.h.r.cl}{number of observations inside the window to the right of the cutoff using conventional s.e.}
\item{sampsi.h.l.cl}{number of observations inside the window to the left of the cutoff using conventional s.e.}
\item{no.iter}{number of iterations until convergence of the Newton-Raphson algorithm}
\item{init.cond}{initial condition of the Newton-Raphson algorithm}
}
\description{
\code{rdsampsi()} performs sample size calculations for RD designs.
}
\examples{
# Toy dataset
X <- array(rnorm(2000),dim=c(1000,2))
R <- X[,1] + X[,2] + rnorm(1000)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(1000)
# Sample size to achieve power of 0.8 against tau = 1
tmp <- rdsampsi(data=cbind(Y,R),tau=1)
# Sample size against tau = 1 including covariates
tmp <- rdsampsi(data=cbind(Y,R),tau=1,covs=X)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2019). \href{https://sites.google.com/site/rdpackages/rdpower/Cattaneo-Titiunik-VazquezBare_2019_Stata.pdf}{Power Calculations for Regression Discontinuity Designs}. \emph{Stata Journal}, 19(1): 210-245.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
