% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_media.R
\name{drop_media}
\alias{drop_media}
\title{Returns a link directly to a file.}
\usage{
drop_media(path = NULL, locale = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{locale}{Dropbox uses the locale parameter to specify language settings
of content responses. If your app supports any language other than English,
insert the appropriate IETF language tag. When a supported language is
specified, Dropbox will returned translated size and/or user_error fields
(where applicable)}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Similar to \code{drop_shared}. The difference is that this bypasses the
Dropbox webserver, used to provide a preview of the file, so that you can
effectively stream the contents of your media. This URL should not be used to
display content directly in the browser. IMPORTANT: The media link will expire
after 4 hours. So you'll need to cache the content with knitr cache OR re-run
the function call after exipry.
}
\examples{
\dontrun{
drop_media('public/gifs/duck_rabbit.gif')
}
}

