% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_get_metadata.R
\name{drop_get_metadata}
\alias{drop_get_metadata}
\title{Retrieve metadata for a file or folder.}
\usage{
drop_get_metadata(
  path,
  include_media_info = FALSE,
  include_deleted = FALSE,
  include_has_explicit_shared_members = FALSE,
  dtoken = get_dropbox_token()
)
}
\arguments{
\item{path}{Path to a file or folder on Dropbox. Can also be an ID ("id:...") or revision ("rev:...").}

\item{include_media_info}{If TRUE, additional metadata for photo or video is returns. Defaults to FALSE.}

\item{include_deleted}{If TRUE, metadata will be returned for a deleted file, otherwise error. Defaults to FALSE.}

\item{include_has_explicit_shared_members}{If TRUE, the results will include a flag for each file indicating whether or not that file has any explicit members. Defaults to FALSE.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\value{
possibly-nested list of all available metadata for specified file/folder/id/revision.
}
\description{
Details vary by input and args.
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#files-get_metadata}{API Documentation}
}
