% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexFTP.R
\name{indexFTP}
\alias{indexFTP}
\title{Create a recursive index of the DWD CDC FTP Server}
\usage{
indexFTP(folder = "currentfindex",
  base = "ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate",
  sleep = 0, dir = "DWDdata", filename = folder[1], overwrite = FALSE,
  quiet = FALSE, progbar = !quiet, verbose = FALSE)
}
\arguments{
\item{folder}{Folder(s) to be indexed recursively, e.g. "/hourly/wind/".
If it is "currentfindex" (the default) and \code{base} is the default,
it is changed to all folders in current \code{\link{fileIndex}}:
\code{unique(dirname(fileIndex$path))}. DEFAULT: "currentfindex"}

\item{base}{Main directory of DWD ftp server, defaulting to observed climatic records.
DEFAULT: \url{ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate}}

\item{sleep}{If not 0, a random number of seconds between 0 and \code{sleep}
is passed to \code{\link{Sys.sleep}} after each read folder
to avoid getting kicked off the FTP-Server. DEFAULT: 0}

\item{dir}{Writeable directory name where to save the downloaded file.
Created if not existent.
DEFAULT: "DWDdata" at current \code{\link{getwd}()}}

\item{filename}{Character: Part of output filename. "INDEX_of_DWD_" is prepended,
"/" replaced with "_", ".txt" appended. DEFAULT: folder[1]}

\item{overwrite}{Logical: Overwrite existing file? If not, "_n" is added to the
filename, see \code{berryFunctions::\link[berryFunctions]{newFilename}}.
DEFAULT: FALSE}

\item{quiet}{Suppress progbars and message about directory/files? DEFAULT: FALSE}

\item{progbar}{Logical: present a progress bar in each level?
Only works if the R package pbapply is available. DEFAULT: TRUE}

\item{verbose}{Logical: write a lot of messages from \code{RCurl::\link[RCurl]{getURL}}?
DEFAULT: FALSE (usually, you dont need all the curl information)}
}
\value{
currently a vector with file paths (output may change in the future)
}
\description{
Create a list of all the files (in subfolders) at the Climate Data Center (CDC)
FTP-Server from the German Weather Service (DWD, Deutscher WetterDienst) at
\url{ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate}.\cr
The R package \code{RCurl} must be available to do this.
If \code{RCurl::\link[RCurl]{getURL}} fails, usually because bot access is
detected and denied, there will still be an output which you can pass in a
second run via \code{folder} to extract the remaining dirs.
You might want to wait a bit and set \code{sleep} to a higher value in that case.
}
\details{
It's not suggested to run this for all folders, as it can take quite some time
and you may get kicked off the FTP-Server. This package contains an index
of the climatic observations at weather stations: \code{View(rdwd:::\link{fileIndex})}
If it is out of date, please let me know!
}
\examples{
\dontrun{ ## Needs internet connection
sol <- indexFTP(folder="/daily/solar")
head(sol)

mon <- indexFTP(folder="/monthly/kl", verbose=TRUE)
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2016
}
\keyword{file}
