% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_extract_replace}
\alias{re2_extract_replace}
\title{Extract with substitutions}
\usage{
re2_extract_replace(string, pattern, rewrite)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}

\item{rewrite}{Rewrite string. Backslash-escaped
digits (\\1 to \\9) can be used to insert text matching
corresponding parenthesized group from the pattern. \\0
refers to the entire matching text.}
}
\value{
A character vector with extractions.
}
\description{
Like \code{\link{re2_replace}}, except that if the pattern matches,
  "rewrite" string is returned with substitutions. The
  non-matching portions of "text" are ignored.

Difference between \code{re2_extract_replace} and \code{\link{re2_replace}}:
\preformatted{
> re2_extract_replace("bunny@wunnies.pl", "(.*)@([^.]*)", "\\2!\\1")
[1] "wunnies!bunny"

> re2_replace("bunny@wunnies.pl", "(.*)@([^.]*)", "\\2!\\1")
[1] "wunnies!bunny.pl"
}
"\\1" and "\\2" are names of capturing subgroups.

Vectorized over string and pattern.
}
\examples{
# Returns extracted string with substitutions
re2_extract_replace(
  "bunny@wunnies.pl",
  "(.*)@([^.]*)",
  "\\\\2!\\\\1"
)

# Case insensitive
re2_extract_replace(
  "BUNNY@wunnies.pl",
  re2_regexp("(b.*)@([^.]*)", case_sensitive = FALSE),
  "\\\\2!\\\\1"
)

# Max submatch too large (1 match group, 2 submatches needed).
#   Replacement fails and empty string is returned.
re2_extract_replace("foo", "f(o+)", "\\\\1\\\\2")

}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax. See
  \code{\link{re2_replace}} and \code{\link{re2_replace_all}} to replace
  pattern in place.
}
