% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{quote_meta}
\alias{quote_meta}
\title{Escapes all potentially meaningful regexp characters in  'unquoted'.}
\usage{
quote_meta(unquoted, parallel = FALSE, grain_size = 1e+05)
}
\arguments{
\item{unquoted}{unquoted string}

\item{parallel}{multithreading support}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms.}
}
\value{
quoted string
}
\description{
The returned string, used as a regular expression, will exactly match the original string.
}
\examples{
quote_meta(c("1.2","abc"))
re2_detect("1+2", "1+2")
re2_detect("1+2", quote_meta("1+2"))
re2_detect("1+2", re2("1+2",literal = TRUE))
}
