% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{colFormat}
\alias{colFormat}
\title{Column formatting options}
\usage{
colFormat(
  prefix = NULL,
  suffix = NULL,
  digits = NULL,
  separators = FALSE,
  percent = FALSE,
  currency = NULL,
  datetime = FALSE,
  date = FALSE,
  time = FALSE,
  hour12 = NULL,
  locales = NULL
)
}
\arguments{
\item{prefix}{Prefix string.}

\item{suffix}{Suffix string.}

\item{digits}{Number of decimal digits to use for numbers.}

\item{separators}{Whether to use grouping separators for numbers, such as
thousands separators or thousand/lakh/crore separators. The format is
locale-dependent.}

\item{percent}{Format number as a percentage? The format is locale-dependent.}

\item{currency}{Currency format. An ISO 4217 currency code such as \code{"USD"}
for the US dollar, \code{"EUR"} for the euro, or \code{"CNY"} for the Chinese RMB.
The format is locale-dependent.}

\item{datetime}{Format as a locale-dependent date-time?}

\item{date}{Format as a locale-dependent date?}

\item{time}{Format as a locale-dependent time?}

\item{hour12}{Whether to use 12-hour time (\code{TRUE}) or 24-hour time (\code{FALSE}).
The default time convention is locale-dependent.}

\item{locales}{Locales to use for number and date/time formatting. A character
vector of BCP 47 language tags, such as \code{"en-US"} for English (United States),
\code{"hi"} for Hindi, or \code{"sv-SE"} for Swedish (Sweden). Defaults to the locale
of the browser.}
}
\value{
A column format object that can be used to customize data formatting
in \code{colDef()}.
}
\description{
Column formatting options
}
\examples{
data <- data.frame(
  price_USD = c(123456.56, 132, 5650.12),
  price_INR = c(350, 23208.552, 1773156.4),
  temp = c(22, NA, 31),
  percent = c(0.9525556, 0.5, 0.112),
  date = as.Date(c("2019-01-02", "2019-03-15", "2019-09-22"))
)

reactable(data, columns = list(
  price_USD = colDef(format = colFormat(prefix = "$", separators = TRUE, digits = 2)),
  price_INR = colDef(format = colFormat(currency = "INR", separators = TRUE, locale = "hi-IN")),
  temp = colDef(format = colFormat(suffix = " \u00b0C")),
  percent = colDef(format = colFormat(percent = TRUE, digits = 1)),
  date = colDef(format = colFormat(date = TRUE, locale = "en-GB"))
))

}
