% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_scales.R
\name{color_scales}
\alias{color_scales}
\title{Add color scales to rows in a column}
\usage{
color_scales(
  data,
  colors = c("#ff3030", "#ffffff", "#1e90ff"),
  bright_values = TRUE,
  span = FALSE
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A vector of colors to color the cells.
Colors should be given in order from low values to high values.
Default colors provided are red-white-blue: c("#ff3030", "#ffffff", "#1e90ff").
Can use R's built-in colors or other color packages.}

\item{bright_values}{Optionally display values as white.
Values with a dark-colored background will be shown in white.
Default is set to TRUE but can be turned off by setting to FALSE.}

\item{span}{Optionally apply colors to values across multiple columns instead of by each column.
To apply across all columns set to TRUE.
If applying to a set of columns, can provide either column names or column positions.
Default is set to FALSE.}
}
\value{
a function that applies conditional colors
    to a column of numeric values.
}
\description{
The `color_scales()` function conditionally colors each cell of a column depending on their value in relation to other values in that particular column.
    It should be placed within the style argument in reactable::colDef.
}
\examples{
data <- iris[10:29, ]

## By default, the colors_scales() function uses a red-white-blue three-color pattern
reactable(data,
 columns = list(
 Petal.Length = colDef(style = color_scales(data))))

## If only two colors are desired,
## you can specify them with colors = 'c(color1, color2)';
reactable(data,
 columns = list(
 Petal.Length = colDef(style = color_scales(data,
 colors = c("red", "green")))))

## Apply color_scales() across all numeric columns using reactable::defaultColDef
reactable(data,
defaultColDef = colDef(style = color_scales(data)))

## Use span to apply colors to values in relation to the entire dataset
reactable(data,
defaultColDef = colDef(style = color_scales(data, span = TRUE)))

## Span can take column names
reactable(data,
defaultColDef = colDef(style = color_scales(data, span = c("Sepal.Length", "Sepal.Width"))))

## Or it can also take column positions instead
reactable(data,
defaultColDef = colDef(style = color_scales(data, span = 1:2)))

}
