% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_min_max.R
\name{highlight_min_max}
\alias{highlight_min_max}
\title{Highlights the minimum and maximum value in a column}
\usage{
highlight_min_max(
  data,
  min_font_color = "red",
  max_font_color = "green",
  min_highlighter = NULL,
  max_highlighter = NULL
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{min_font_color}{color to assign to minimum value in a column.
Default color is red.}

\item{max_font_color}{color to assign to maximum value in a column.
Default color is green.}

\item{min_highlighter}{color to assign the background of a cell containing minimum value in a column.}

\item{max_highlighter}{color to assign the background of a cell containing maximum value in a column.}
}
\value{
a function that applies a color
    to the minimum and maximum values in a column of numeric values.
}
\description{
The `highlight_min_max()` function assigns a font color and/or background color to both the minimum and maximum values in a column.
    It should be placed within the style argument in reactable::colDef.
}
\examples{
data <- MASS::road[11:17, ]

## By default, the minimum and maximum values are bold with a red and green font color respectively
reactable(data,
defaultColDef = colDef(
    style = highlight_min_max(data)))

## Assign a different font color to the min and max values
reactable(data,
defaultColDef = colDef(
    style = highlight_min_max(data,
    min_font_color = "orange",
    max_font_color = "blue")))

## Highlight the background of the cell for the min and max values in each column
reactable(data,
defaultColDef = colDef(
    style = highlight_min_max(data,
    min_highlighter = "salmon",
    max_highlighter = "skyblue")))

}
