% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{getLocusColumns}
\alias{getLocusColumns}
\alias{getLocusColumns.genalex}
\title{Determine numeric column positions occupied by named loci}
\usage{
\method{getLocusColumns}{genalex}(x, locus, ...)
}
\arguments{
\item{x}{An annotated data frame created by \code{readGenalex}}

\item{locus}{The names of one or more loci found in \code{x}}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
A vector of column positions occupied by genotype data for loci
named in \code{locus}.
}
\description{
Determine the numeric column positions occupied by named loci in an
object of class \code{'genalex'}.  This is mostly used as
a utility routine by other functions in the \code{readGenalex} package.
}
\examples{
data(Qagr_adult_genotypes)
getLocusColumns(Qagr_adult_genotypes, c("0c19", "0m05"))
}
\author{
Douglas G. Scofield
}

