% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs_data.R
\name{read_abs_data}
\alias{read_abs_data}
\title{Extracts ABS-formatted data directly from Excel spreadsheets and converts to long format.}
\usage{
read_abs_data(path, sheet)
}
\arguments{
\item{path}{Filepath to Excel spreadsheet.}

\item{sheet}{Sheet name or number.}
}
\value{
Long-format dataframe
}
\description{
Extracts ABS-formatted data directly from Excel spreadsheets and converts to long format.
}
\examples{
\donttest{
data <- system.file("extdata","5206002_expenditure_volume_measures.xls", package = "readabs")
read_abs_data(path= data, sheet=2)
}



}
