% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2.R
\name{read_dhis2}
\alias{read_dhis2}
\title{Import data from DHIS2}
\usage{
read_dhis2(login, org_unit, program)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}

\item{org_unit}{A character with the organisation unit ID or name}

\item{program}{A character with the program ID or name}
}
\value{
A data frame that contains both the tracked entity attributes and
their event data.
}
\description{
Import data from DHIS2
}
\examples{
\dontrun{
  # login to the DHIS2 instance
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )
  program = "E5IUQuHg3Mg"
  org_unit = "GcLhRNAFppR"
  data <- read_dhis2(
    login = dhis2_login,
    org_unit = org_unit,
    program = program
  )

  # fetch data from the test DHIS2 instance
  dhis2_login <- login(
    type = "dhis2",
    from = "https://play.im.dhis2.org/stable-2-42-1",
    user_name = "admin",
    password = "district"
  )
  org_unit <- "DiszpKrYNg8"
  program <- "IpHINAT79UW"

  data <- read_dhis2(
    login = dhis2_login,
    org_unit = org_unit,
    program = program
  )
}
}
