% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/type_convert.R
\name{type_convert}
\alias{type_convert}
\title{Re-convert character columns in existing data frame.}
\usage{
type_convert(df, col_types = NULL)
}
\arguments{
\item{df}{A data frame.}

\item{col_types}{One of \code{NULL}, a list, a named list or a string.

  If \code{NULL}, the column type will be imputed from the first 30 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a list, it must contain one "\code{\link{collector}}" for each column.
  If you only want to read a subset of the columns, you can use a named list
  (where the names give the column names). If a column is not mentioned by
  name, it will not be included in the output.

  Alternatively, you can use a compact string representation where each
  character represents one column: c = character, d = double, i = integer,
  l = logical and \code{_} skips the column.}
}
\description{
This is useful if you need to do some manual munging - you can read the
columns in as character, clean it up with (e.g.) regular expressions and
then let readr take another stab at parsing it.
}
\examples{
df <- data.frame(
  x = as.character(runif(10)),
  y = as.character(sample(10)),
  stringsAsFactors = FALSE
)
str(df)
str(type_convert(df))
}

