% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fwf.R
\name{read_fwf}
\alias{read_fwf}
\alias{fwf_empty}
\alias{fwf_widths}
\alias{fwf_positions}
\alias{fwf_cols}
\title{Read a fixed width file into a tibble}
\usage{
read_fwf(
  file,
  col_positions = fwf_empty(file, skip, n = guess_max),
  col_types = NULL,
  col_select = NULL,
  id = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  n_max = Inf,
  guess_max = min(n_max, 1000),
  progress = show_progress(),
  name_repair = "unique",
  num_threads = readr_threads(),
  show_col_types = should_show_types(),
  lazy = TRUE,
  skip_empty_rows = TRUE
)

fwf_empty(
  file,
  skip = 0,
  skip_empty_rows = FALSE,
  col_names = NULL,
  comment = "",
  n = 100L
)

fwf_widths(widths, col_names = NULL)

fwf_positions(start, end = NULL, col_names = NULL)

fwf_cols(...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as a
path, it must be wrapped with \code{I()}, be a string containing at least one
new line, or be a vector containing at least one string with a new line.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_positions}{Column positions, as created by \code{\link[=fwf_empty]{fwf_empty()}},
\code{\link[=fwf_widths]{fwf_widths()}} or \code{\link[=fwf_positions]{fwf_positions()}}. To read in only selected fields,
use \code{\link[=fwf_positions]{fwf_positions()}}. If the width of the last column is variable (a
ragged fwf file), supply the last end position as NA.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be imputed from the first 1000 rows
on the input. This is convenient (and fast), but not robust. If the
imputation fails, you'll need to increase the \code{guess_max} or supply the
correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[=cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set `options(readr.show_col_types = FALSE).
}}

\item{col_select}{<\code{\link[tidyselect:language]{tidy-select}}> Columns to include
in the results, either by name or by numeric index. Use \code{\link[=c]{c()}} or \code{\link[=list]{list()}}
to select with more than one expression and \code{\link[tidyselect:language]{?tidyselect::language}} for full
details on the selection language.}

\item{id}{The name of a column in which to store the file path. This is
useful when reading multiple input files and there is data in the file
paths, such as the data collection date. If \code{NULL} (the default) no extra
column is created.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{guess_max}{Maximum number of lines to use for guessing column types.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The automatic
progress bar can be disabled by setting option \code{readr.show_progress} to
\code{FALSE}.}

\item{name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence of names
\item \code{"unique"}: Make sure names are unique and not empty
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique}
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R)
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{num_threads}{The number of processing threads to use for initial
parsing and lazy reading of data. If your data contains newlines within
fields the parser should automatically detect this and fall back to using
one thread only. However if you know your file has newlines within quoted
fields it is safest to set \code{num_threads = 1} explicitly.}

\item{show_col_types}{If \code{FALSE}, do not show the guessed column types. If
\code{TRUE} always show the column types, even if they are supplied. If \code{NULL}
(the default) only show the column types if they are not explicitly supplied
by the \code{col_types} argument.}

\item{lazy}{Read values lazily? By default the file is initially only
indexed and the values are read lazily when accessed. Lazy reading is
useful interactively, particularly if you are only interested in a subset
of the full dataset. Note, lazy reading on windows will lock the file
until all the data has been read from it, if you run into this issue set
\code{lazy = FALSE}.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}

\item{col_names}{Either NULL, or a character vector column names.}

\item{n}{Number of lines the tokenizer will read to determine file structure. By default
it is set to 100.}

\item{widths}{Width of each field. Use NA as width of last field when
reading a ragged fwf file.}

\item{start, end}{Starting and ending (inclusive) positions of each field.
Use NA as last end field when reading a ragged fwf file.}

\item{...}{If the first element is a data frame,
then it must have all numeric columns and either one or two rows.
The column names are the variable names. The column values are the
variable widths if a length one vector, and if length two, variable start and end
positions. The elements of \code{...} are used to construct a data frame
with or or two rows as above.}
}
\description{
A fixed width file can be a very compact representation of numeric data.
It's also very fast to parse, because every field is in the same place in
every line. Unfortunately, it's painful to parse because you need to
describe the length of every field. Readr aims to make it as easy as possible
by providing a number of different ways to describe the field structure.
\itemize{
\item \code{\link[=fwf_empty]{fwf_empty()}} - Guesses based on the positions of empty columns.
\item \code{\link[=fwf_widths]{fwf_widths()}} - Supply the widths of the columns.
\item \code{\link[=fwf_positions]{fwf_positions()}} - Supply paired vectors of start and end positions.
\item \code{\link[=fwf_cols]{fwf_cols()}} - Supply named arguments of paired start and end positions or column widths.
}
}
\section{Second edition changes}{

Comments are no longer looked for anywhere in the file.
They are now only ignored at the start of a line.
}

\examples{
fwf_sample <- readr_example("fwf-sample.txt")
writeLines(read_lines(fwf_sample))

# You can specify column positions in several ways:
# 1. Guess based on position of empty columns
read_fwf(fwf_sample, fwf_empty(fwf_sample, col_names = c("first", "last", "state", "ssn")))
# 2. A vector of field widths
read_fwf(fwf_sample, fwf_widths(c(20, 10, 12), c("name", "state", "ssn")))
# 3. Paired vectors of start and end positions
read_fwf(fwf_sample, fwf_positions(c(1, 30), c(20, 42), c("name", "ssn")))
# 4. Named arguments with start and end positions
read_fwf(fwf_sample, fwf_cols(name = c(1, 20), ssn = c(30, 42)))
# 5. Named arguments with column widths
read_fwf(fwf_sample, fwf_cols(name = 20, state = 10, ssn = 12))
}
\seealso{
\code{\link[=read_table]{read_table()}} to read fixed width files where each
column is separated by whitespace.
}
