% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{parse_guess}
\alias{parse_guess}
\alias{col_guess}
\alias{guess_parser}
\title{Parse using the "best" type}
\usage{
parse_guess(
  x,
  na = c("", "NA"),
  locale = default_locale(),
  trim_ws = TRUE,
  guess_integer = FALSE
)

col_guess()

guess_parser(
  x,
  locale = default_locale(),
  guess_integer = FALSE,
  na = c("", "NA")
)
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{guess_integer}{If \code{TRUE}, guess integer types for whole numbers, if
\code{FALSE} guess numeric type for all numbers.}
}
\description{
\code{parse_guess()} returns the parser vector; \code{guess_parser()}
returns the name of the parser. These functions use a number of heuristics
to determine which type of vector is "best". Generally they try to err of
the side of safety, as it's straightforward to override the parsing choice
if needed.
}
\examples{
# Logical vectors
parse_guess(c("FALSE", "TRUE", "F", "T"))

# Integers and doubles
parse_guess(c("1", "2", "3"))
parse_guess(c("1.6", "2.6", "3.4"))

# Numbers containing grouping mark
guess_parser("1,234,566")
parse_guess("1,234,566")

# ISO 8601 date times
guess_parser(c("2010-10-10"))
parse_guess(c("2010-10-10"))
}
\seealso{
Other parsers: 
\code{\link{col_skip}()},
\code{\link{cols_condense}()},
\code{\link{cols}()},
\code{\link{parse_datetime}()},
\code{\link{parse_factor}()},
\code{\link{parse_logical}()},
\code{\link{parse_number}()},
\code{\link{parse_vector}()}
}
\concept{parsers}
