% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dbcal.R
\name{as.caldays}
\alias{as.caldays}
\title{Convert Stata business calendar dates in readable dates.}
\usage{
as.caldays(buisdays, cal, format = "\%Y-\%m-\%d")
}
\arguments{
\item{buisdays}{numeric Vector of business dates}

\item{cal}{data.frame Conversion table for business calendar dates}

\item{format}{character String with date format as in \code{\link{as.Date}}}
}
\value{
Returns a vector of readable dates.
}
\description{
Convert Stata business calendar dates in readable dates.
}
\examples{
# read business calendar and data
sp500 <- stbcal(system.file("extdata/sp500.stbcal", package="readstata13"))
dat <- read.dta13(system.file("extdata/statacar.dta", package="readstata13"))

# convert dates and check
dat$ldatescal2 <- as.caldays(dat$ldate, sp500)
all(dat$ldatescal2==dat$ldatescal)
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}

