% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tools.R
\name{get.origin.codes}
\alias{get.origin.codes}
\title{Get Origin Code Numbers for Factors}
\usage{
get.origin.codes(x, label.table)
}
\arguments{
\item{x}{\emph{factor.} Factor to obtain code for}

\item{label.table}{\emph{table.} Table with factor levels obtained by \code{\link{get.label}}.}
}
\value{
Returns an integer with original codes
}
\description{
Recreates the code numbers of a factor as stored in the Stata dataset.
}
\details{
While converting numeric variables into factors, the original code numbers are lost.  This function reconstructs the codes from the attribute \code{label.table}.
}
\examples{
dat <- read.dta13(system.file("extdata/statacar.dta", package="readstata13"))
labname <- get.label.name(dat,"type")
labtab <- get.label(dat, labname)

# comparsion
get.origin.codes(dat$type, labtab)
as.integer(dat$type)
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}

