% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.R
\name{rws_drop_table}
\alias{rws_drop_table}
\title{Drop SQLite Table}
\usage{
rws_drop_table(table_name, conn)
}
\arguments{
\item{table_name}{A string of the name of the table.}

\item{conn}{A \linkS4class{SQLiteConnection} to a database.}
}
\value{
TRUE
}
\description{
Drops SQLite table using DROP TABLE.
}
\details{
Also drops rows from meta and init tables.
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_list_tables(conn)
rws_drop_table("rws_data", conn = conn)
rws_list_tables(conn)
rws_disconnect(conn)
}
\references{
\url{https://www.sqlite.org/lang_droptable.html}
}
\seealso{
Other rws_rename: 
\code{\link{rws_rename_column}()},
\code{\link{rws_rename_table}()}
}
\concept{rws_rename}
