% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_origin_fn.R
\name{create_origin_fn}
\alias{create_origin_fn}
\title{Create origin_fn function}
\usage{
create_origin_fn(fn, ...)
}
\arguments{
\item{fn}{Function to apply to each dimension. Should return a numeric scalar.}

\item{...}{Arguments for \code{`fn`}. E.g. \code{`na.rm = TRUE`}.}
}
\value{
Function with the dots (\code{...}) argument that applies the \code{`fn`} function to
each element in \code{...} (usually one vector per dimension).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Creates a function that applies a supplied function to all input vectors.
}
\examples{
# Attach packages
library(rearrr)

# Set seed
set.seed(1)

# Create three vectors
x <- runif(10)
y <- runif(10)
z <- runif(10)

# Create origin_fn that gets the median of each dimension
median_origin_fn <- create_origin_fn(median)

# Use median_origin_fn
median_origin_fn(x, y, z)

# Should be the same as
c(median(x), median(y), median(z))

# Use mean and ignore missing values
mean_origin_fn <- create_origin_fn(mean, na.rm = TRUE)

# Add missing values
x[[2]] <- NA
y[[5]] <- NA

# Use mean_origin_fn
mean_origin_fn(x, y, z)

# Should be the same as
c(mean(x, na.rm = TRUE),
  mean(y, na.rm = TRUE),
  mean(z, na.rm = TRUE)
)
}
\seealso{
Other coordinate functions: 
\code{\link{centroid}()},
\code{\link{is_most_centered}()},
\code{\link{midrange}()},
\code{\link{most_centered}()}

Other function creators: 
\code{\link{create_dimming_fn}()},
\code{\link{create_n_fn}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{coordinate functions}
\concept{function creators}
