% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num2factor.R
\name{step_num2factor}
\alias{step_num2factor}
\alias{tidy.step_num2factor}
\title{Convert Numbers to Factors}
\usage{
step_num2factor(recipe, ..., role = NA, transform = function(x) x,
  trained = FALSE, levels = NULL, ordered = FALSE, skip = FALSE,
  id = rand_id("num2factor"))

\method{tidy}{step_num2factor}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will converted to factors. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{transform}{A function taking a single argument \code{x} that
can be used to modify the numeric values prior to determining
the levels (perhaps using \code{\link[base:paste]{base::paste()}} or \code{\link[base:format]{base::format()}}).}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{levels}{A list of values that will be used as the levels.
These are the numeric data converted to character and ordered.
This is \code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{ordered}{A single logical value; should the factor(s) be
ordered?}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_num2factor} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{ordered}.
}
\description{
\code{step_num2factor} will convert one or more numeric
vectors to factors (ordered or unordered). This can be useful
when categories are encoded as integers.
}
\note{
If \code{bake} is used on a data set where a new value is
in the column being converted, \code{bake} will silently give values
of \code{NA} to these rows (see the example below).
}
\examples{
iris2 <- iris
iris2$Species <- as.numeric(iris2$Species)

rec <- recipe(~ ., data = iris2)

make_factor <- rec \%>\% step_num2factor(Species)
make_factor <- prep(make_factor,
                    training = iris2,
                    retain = TRUE)

# note that `diet` is a factor
juice(make_factor) \%>\% head
okc \%>\% head
tidy(make_factor, number = 1)

# When novel values are exposed
with_transform <- rec \%>\%
  step_num2factor(Species, transform = function(x) paste0("val_", x))

with_transform <- prep(with_transform,
                       training = iris2[1:75,])
new_values <- bake(with_transform, new_data = iris2, Species)
table(new_values[["Species"]], iris2$Species, useNA = "ifany")
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}}, \code{\link[=step_string2factor]{step_string2factor()}},
\code{\link[=step_dummy]{step_dummy()}}
}
\concept{preprocessing variable_encodings factors}
\keyword{datagen}
