% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colcheck.R
\name{check_cols}
\alias{check_cols}
\title{Check if all Columns are Present}
\usage{
check_cols(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  skip = FALSE,
  id = rand_id("cols")
)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this check. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this check since no new variables are
created.}

\item{trained}{A logical for whether the selectors in \code{...}
have been resolved by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this check to identify it.}
}
\value{
An updated version of \code{recipe} with the new check added to the
sequence of any existing operations.
}
\description{
\code{check_cols} creates a \emph{specification} of a recipe
step that will check if all the columns of the training frame are
present in the new data.
}
\details{
This check will break the \code{bake} function if any of the specified
columns is not present in the data. If the check passes, nothing is changed
to the data.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this check, a tibble with columns
\code{terms} (the selectors or variables selected) and \code{value} (the type)
is returned.
}

\examples{

library(modeldata)
data(biomass)

biomass_rec <- recipe(HHV ~ ., data = biomass) \%>\%
   step_rm(sample, dataset) \%>\%
   check_cols(contains("gen")) \%>\%
   step_center(all_numeric_predictors())

\dontrun{
bake(biomass_rec, biomass[, c("carbon", "HHV")])
}
}
\seealso{
Other checks: 
\code{\link{check_class}()},
\code{\link{check_missing}()},
\code{\link{check_new_values}()},
\code{\link{check_range}()}
}
\concept{checks}
